#!/bin/bash

# Some colors for a brighter look
RS="\033[0m"
RE="\033[1;31;40m"
GR="\033[1;32;40m"
BR="\033[0;33;40m"
YE="\033[1;33;40m"
WH="\033[1;37;40m"
BLK="\033[1;37;40m"
CLR="\033[2J\033[H"

function create_bashrc() {
    if [ -f ~/.bashrc ]; then
        # Check if first line contains the incorrect assertion
        if head -1 ~/.bashrc | grep -q "for non-login shells"; then
            sed -e '1s/for non-login shells/for interactive shells/' ~/.bashrc >/tmp/__bash_setup__ && \
                mv -f /tmp/__bash_setup__ ~/.bashrc
        fi
    else
        echo "# ~/.bashrc: executed by bash(1) for interactive shells" >~/.bashrc
    fi
}

echo -ne "${BLK}${CLR}"
echo -e "${WH}--- Welcome to GNU Bash! ---"
echo -e "${GR}Looks like you haven't set up bash"
echo -e "${GR}for this account yet. This script"
echo -e "${GR}will help you do it."
echo    ""
echo -e "${BR}Enter ${YE}Y${BR} to set up bash now, or"
echo -e "${BR}Enter ${YE}N${BR} to exit and never ask you again."
echo -e "${BR}Enter ${YE}L${BR} to do it later."

while true; do
    echo -ne "${WH}"
    read -r -p "> " x
    case $x in
        y|Y)
            break;;
        n|N)
            create_bashrc
            echo -ne "${RS}${CLR}"
            exit;;
        l|L)
            echo -ne "${RS}${CLR}"
            exit;;
    esac
    echo -e "${RE}Please enter ${YE}Y${RE}, ${YE}N${RE} or ${YE}L"
done

create_bashrc

echo -ne "${BLK}${CLR}"
echo -e "${GR}Do you want to use ${YE}bash${GR} as your default"
echo -e "${GR}login shell?"
echo    ""
echo -e "${BR}Enter ${YE}Y${BR} to change shell to ${YE}bash${BR}, or"
echo -e "${BR}Enter ${YE}N${BR} to leave the current shell setting."

SET_SHELL=
while true; do
    echo -ne "${WH}"
    read -r -p "> " x
    case $x in
        y|Y)
            SET_SHELL=y
            break;;
        n|N)
            break;;
    esac
    echo -e "${RE}Please enter ${YE}Y${RE} or ${YE}N"
done

if [ -n "$SET_SHELL" ]; then
    chsh -s /bin/bash $USER
fi

# Looks like there's a leftover .bashrc in /root,
# which will override any prompt we set
if [ `id -u` == 0 -a -w /root/.bashrc ]; then
    echo A
    if grep -q '^export PS1='\''\\h:\\w\\\$ '\''$' /root/.bashrc; then
        echo B
        echo -ne "${BLK}${CLR}"
        echo -e "${GR}It seems there is a leftover ~/.bashrc in your home"
        echo -e "${GR}directory. It will override the prompt set by the"
        echo -e "${GR}/etc/profile.d/prompt.sh script. Do you want to comment"
        echo -e "${GR}out the line that sets the prompt in ~/.bashrc?"
        echo    ""
        echo -e "${BR}Enter ${YE}Y${BR} to comment out the line, or"
        echo -e "${BR}Enter ${YE}N${BR} to leave ~/.bashrc intact."

        FIX_BASHRC=
        while true; do
            echo -ne "${WH}"
            read -r -p "> " x
            case $x in
                y|Y)
                    FIX_BASHRC=y
                    break;;
                n|N)
                    break;;
            esac
            echo -e "${RE}Please enter ${YE}Y${RE} or ${YE}N"
        done

        if [ -n "$FIX_BASHRC" ]; then
            sed -e 's/^\(export PS1=.*\)$/# \1/' /root/.bashrc >/tmp/__bash_setup__
            mv -f /tmp/__bash_setup__ /root/.bashrc
        fi
    fi
fi

echo -ne "${RS}${CLR}"
