#ifndef REPOSTAT_H
#define REPOSTAT_H

#include <QMainWindow>
#include <QSettings>
#include <QNetworkAccessManager>
#include <QNetworkReply>

#include <ui_repostat.h>

class RepoStat : public QMainWindow
{
    Q_OBJECT

private slots:
    void toggleFullScreen(bool b);
    void loadStat(QNetworkReply* reply);
    void showRepoChooser();
    void showRangeChooser();

private:
    QNetworkAccessManager *manager;
    Ui::RepoStat ui;
    QSettings settings;
    void getData();
    void resizeEvent(QResizeEvent* event);
public:
    RepoStat(QWidget *parent = 0);
    ~RepoStat();

};

#endif // REPOSTAT_H
