#include "repohist.h"
#include "fremantlerepochooser.h"
#include "rangepicker.h"
#include "ui_applistitem.h"
#include <QNetworkDiskCache>
#include <QDebug>
#include <QFileInfo>
#include <QTextStream>
#include <QDateTime>

RepoHist::RepoHist(QWidget* parent): QMainWindow(parent), ui(new Ui::AppList), settings("AppWatch", "RepoHist")
{
    ui->setupUi(this);
    ui->scrollArea->setProperty("FingerScrollable", true);
    ui->scrollArea->setProperty("FingerScrollBars", true);


    connect(ui->actionRepository_filter, SIGNAL(triggered()), this, SLOT(showRepoChooser()));
    connect(ui->action_Date_range, SIGNAL(triggered()), this, SLOT(showRangeChooser()));


    manager = new QNetworkAccessManager(this);
    qDebug() << settings.fileName();
    QNetworkDiskCache *diskCache = new QNetworkDiskCache(this);
    diskCache->setCacheDirectory(QFileInfo(settings.fileName()).absolutePath() + "/cacheDir");
    manager->setCache(diskCache);

    getData();

    connect(manager, SIGNAL(finished(QNetworkReply*)), this, SLOT(loadStat(QNetworkReply*)));
}

void RepoHist::showRangeChooser()
{
    RangePicker rp(settings.value("interval", QVariant("m")).toString());
    if (rp.exec() > 0)
        settings.setValue("interval", rp.range());
        getData();
}

void RepoHist::showRepoChooser()
{
    FremantleRepoChooser rc("RepoHist");
    if (rc.exec() > 0)
        getData();
}

void RepoHist::getData()
{
    QString interval = settings.value("interval", QVariant("m")).toString();

    // do a request preferred from cache
    QNetworkRequest request(QUrl(QString("http://app.cache.rs/repohist?scale=%1").arg(interval)));
//    request.setAttribute(QNetworkRequest::CacheLoadControlAttribute, QNetworkRequest::AlwaysCache);
    request.setAttribute(QNetworkRequest::CacheLoadControlAttribute, QNetworkRequest::PreferCache);
    manager->get(request);
}


void RepoHist::loadStat(QNetworkReply* reply)
{

    QVariant fromCache = reply->attribute(QNetworkRequest::SourceIsFromCacheAttribute);
    qDebug() << "hist page from cache?" << fromCache.toBool();

    if (settings.allKeys().length() == 0) { // none selected, cludgy way to get defaults
        FremantleRepoChooser* rc = new FremantleRepoChooser("RepoHist");
        rc->saveChoice();
        delete rc;
    }

    ////
    ////  Load graph data
    ////
    if (!reply->open(QIODevice::ReadOnly | QIODevice::Text)){
       return;
    }
    QTextStream in(reply);
    QString lastline = "";
    bool skipds = true; // set this to true to avoid referencing a datasourec before the first one
    int elemcount = 0;
    Ui::AppListItem* ali = new Ui::AppListItem();
    QWidget* item = new QWidget;
    ali->setupUi(item);
    ui->verticalLayout->insertWidget(0, item);
    while (!in.atEnd()) {
        QString line = in.readLine();
        QStringList list = line.split(",");
        ali = new Ui::AppListItem();
        item = new QWidget;
        ali->setupUi(item);
        ali->date->setText(QDateTime::fromTime_t(list[0].toInt()).toString(Qt::SystemLocaleShortDate));
        ali->repo->setText(list[1].left(1).toUpper() + (list[2] == "extras" ? "E" : QString(list[2].at(7)).toUpper()));
        ali->name->setText(list[3]);
        ali->version->setText(list[4].split("-")[0]);
        if (ali->repo->text()[1] == 'E') { // extras has stars
            ali->rating->setText(QString().fill('*', list[5].toInt()));
//            connect(item, SIGNAL(
        } else if (ali->repo->text()[1] == 'T') { // testing has karma
            ali->rating->setText(list[5]+"/10");
        } else {
            ali->rating->setText("DEV");
        }
        ali->status->setText(list[6]);
        int age = QDateTime::currentDateTime().toTime_t()- list[0].toInt();
        if ((age > 30 * 86400 && settings.value("interval", QString("m")) == "m") ||
            (age > 7 * 86400 && settings.value("interval", QString("m")) == "w") ||
            (age > 365 * 86400 && settings.value("interval", QString("m")) == "y"))
            continue;
        if (settings.value(QString("%1/%2").arg(list[1]).arg(list[2]), 0) == 0)
            continue;
        ui->verticalLayout->insertWidget(++elemcount, item);

//       AppListItem* ali = new AppListItem();
//       ali->ui->repo->setText("q");
    }

    // status repo application version rating date
/*
       1261062602,fremantle,extras,crimson,0.5.3-1maemo4,added
       1261059002,fremantle,extras-devel,mrawviewer,1.1-2,updated
       1261059002,fremantle,extras-devel,beneath-a-steel-sky,0.0372-3maemo4,added
       1261059002,fremantle,extras,liqflow,0.1.1,added
       1261059002,fremantle,extras,pidgin,2.6.3-6nix0,added
       1261055402,fremantle,extras-testing,webtexter,0.6,updated
*/

}

