#include "repochooser.h"
#include "ui_repochooser.h"

RepoChooser::RepoChooser(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::RepoChooser),
    settings("AppWatch", "RepoStat")
{
    ui->setupUi(this);
    ui->cDevel->setChecked(settings.value("chinook/extras-devel",     QVariant(ui->cDevel->checkState())).toBool());
    ui->dDevel->setChecked(settings.value("diablo/extras-devel",      QVariant(ui->dDevel->checkState())).toBool());
    ui->fDevel->setChecked(settings.value("fremantle/extras-devel",   QVariant(ui->fDevel->checkState())).toBool());
    ui->dExtras->setChecked(settings.value("diablo/extras",             QVariant(ui->dExtras->checkState())).toBool());
    ui->fExtras->setChecked(settings.value("fremantle/extras",          QVariant(ui->fExtras->checkState())).toBool());
    ui->fTesting->setChecked(settings.value("fremantle/extras-testing", QVariant(ui->fTesting->checkState())).toBool());

    QString interval = settings.value("interval", QVariant(ui->buttonGroup->checkedButton()->objectName()).toString()).toString();
    if (interval == "y") ui->y->setChecked(true);
    else if (interval == "w") ui->w->setChecked(true);
    else ui->m->setChecked(true);

    connect(ui->buttonBox, SIGNAL(accepted()), this, SLOT(saveChoice()));

    saveChoice();
}

void RepoChooser::saveChoice()
{
    settings.setValue("chinook/extras-devel",     ui->cDevel->checkState());
    settings.setValue("diablo/extras-devel",      ui->dDevel->checkState());
    settings.setValue("fremantle/extras-devel",   ui->fDevel->checkState());
    settings.setValue("diablo/extras",     ui->dExtras->checkState());
    settings.setValue("fremantle/extras",  ui->fExtras->checkState());
    settings.setValue("fremantle/extras-testing", ui->fTesting->checkState());
    QString interval = ui->buttonGroup->checkedButton()->objectName();
    settings.setValue("interval", interval);
    settings.sync();
}

RepoChooser::~RepoChooser()
{
    delete ui;
}

void RepoChooser::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
