#include "rangepicker.h"
#include "ui_rangepicker.h"

RangePicker::RangePicker(QString def, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::RangePicker)
{
    ui->setupUi(this);
    if (def == "w") ui->w->setChecked(true);
    else if (def == "y") ui->y->setChecked(true);
    else ui->m->setChecked(true);
    if (def != "w")
        connect(ui->w, SIGNAL(clicked()), this, SLOT(accept()));
    if (def != "y")
        connect(ui->y, SIGNAL(clicked()), this, SLOT(accept()));
    if (def != "m")
        connect(ui->m, SIGNAL(clicked()), this, SLOT(accept()));
}

QString RangePicker::range()
{
    if (ui->w->isChecked()) return QString("w");
    else if (ui->y->isChecked()) return QString("y");
    else return QString("m");
}

RangePicker::~RangePicker()
{
    delete ui;
}

void RangePicker::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
