#include "mainwindow.h"
#include "repostat.h"
#include "repohist.h"
#include "appforecast.h"
#include "hotapps.h"

#include <QMessageBox>
#include <QtDBus>

#ifdef Q_WS_MAEMO_5
#include <QtMaemo5/QMaemo5KineticScroller>
#endif

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

    ui.setupUi(this);
    connect(ui.actionAbout_Qt, SIGNAL(triggered()), qApp, SLOT(aboutQt()));
    connect(ui.actionAbout_AppWatch, SIGNAL(triggered()), this, SLOT(about()));
    connect(ui.actionMaemo_Select, SIGNAL(triggered()), qApp, SLOT(selectMaemo()));
    connect(ui.actionMaemo_org_downloads, SIGNAL(triggered()), qApp, SLOT(maemoOrg()));
    connect(ui.action_Ovi_store, SIGNAL(triggered()), qApp, SLOT(oviStore()));
    connect(ui.action_Update_data, SIGNAL(triggered()), qApp, SLOT(expireCache()));

    connect(ui.aForecast, SIGNAL(clicked()), this, SLOT(appForecast()));
    connect(ui.rStat, SIGNAL(clicked()), this, SLOT(repoStat()));
    connect(ui.rHist, SIGNAL(clicked()), this, SLOT(repoHist()));
    connect(ui.aStat, SIGNAL(clicked()), this, SLOT(hotApps()));
    connect(ui.aDisk, SIGNAL(clicked()), this, SLOT(diskUsage()));
//#ifdef Q_WS_MAEMO_5
//    ui.menubar->addAction(ui.actionAbout_Qt);
//    ui.menubar->addAction(ui.actionAbout_AppWatch);
//    ui.menubar->addAction(ui.action_Update_data);
//#endif
    submw = NULL;
}

void MainWindow::repoStat()
{
    delete submw;
    submw = new RepoStat(this);
#ifdef Q_WS_MAEMO_5
    submw->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    submw->show();
}

void MainWindow::repoHist()
{
    delete submw;
    submw = new RepoHist(this);
#ifdef Q_WS_MAEMO_5
    submw->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    submw->show();
}

void MainWindow::appForecast()
{
    delete submw;
    submw = new AppForecast(this);
#ifdef Q_WS_MAEMO_5
    submw->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    submw->show();
}

void MainWindow::develApp()
{}

void MainWindow::expireCache()
{}

void MainWindow::diskUsage()
{}

void MainWindow::oviStore()
{
    QDBusInterface browser("com.nokia.osso_browser", "/com/nokia/osso_browser/request", "com.nokia.osso_browser")  ;
    browser.call("open_new_window", "http://store.ovi.com");
}
void MainWindow::maemoOrg()
{
    QDBusInterface browser("com.nokia.osso_browser", "/com/nokia/osso_browser/request", "com.nokia.osso_browser")  ;
    browser.call("open_new_window", "http://downloads.maemo.org");
}
void MainWindow::selectMaemo()
{
    QDBusInterface browser("com.nokia.osso_browser", "/com/nokia/osso_browser/request", "com.nokia.osso_browser")  ;
    browser.call("open_new_window", "http://maemo.nokia.com/maemo-select/");
//    QDBusConnection c = QDBusConnection::sessionBus()   ;
//    QDBusMessage m = QDBusMessage::createSignal("/","com.nokia.osso_browser","load_url string: downloads.maemo.org");
//    c.send(m);
}

void MainWindow::hotApps()
{
    delete submw;
    submw = new HotApps(this);
#ifdef Q_WS_MAEMO_5
    submw->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    submw->show();
}

void MainWindow::about()
{
   QMessageBox::about(this, tr("About AppWatch"),
                      tr("<b>AppWatch</b> Copyright (C) 2009, Attila Csipa"));
}


MainWindow::~MainWindow()
{

}
