#include "fremantlerepochooser.h"
#include "ui_fremantlerepochooser.h"

FremantleRepoChooser::FremantleRepoChooser(QString component, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::FremantleRepoChooser),
    settings("AppWatch", component)
{
    ui->setupUi(this);
    ui->scrollArea->setProperty("FingerScrollable", true);
    connect(ui->buttonBox, SIGNAL(accepted()), this, SLOT(saveChoice()));

    ui->cDevel->setChecked(settings.value("chinook/extras-devel",     QVariant(ui->cDevel->checkState())).toBool());
    ui->dDevel->setChecked(settings.value("diablo/extras-devel",      QVariant(ui->dDevel->checkState())).toBool());
    ui->fDevel->setChecked(settings.value("fremantle/extras-devel",   QVariant(ui->fDevel->checkState())).toBool());
    ui->dExtras->setChecked(settings.value("diablo/extras",             QVariant(ui->dExtras->checkState())).toBool());
    ui->fExtras->setChecked(settings.value("fremantle/extras",          QVariant(ui->fExtras->checkState())).toBool());
    ui->fTesting->setChecked(settings.value("fremantle/extras-testing", QVariant(ui->fTesting->checkState())).toBool());

}


void FremantleRepoChooser::saveChoice()
{
    settings.setValue("chinook/extras-devel",     ui->cDevel->checkState());
    settings.setValue("diablo/extras-devel",      ui->dDevel->checkState());
    settings.setValue("fremantle/extras-devel",   ui->fDevel->checkState());
    settings.setValue("diablo/extras",     ui->dExtras->checkState());
    settings.setValue("fremantle/extras",  ui->fExtras->checkState());
    settings.setValue("fremantle/extras-testing", ui->fTesting->checkState());
    settings.sync();
}

FremantleRepoChooser::~FremantleRepoChooser()
{
    delete ui;
}

void FremantleRepoChooser::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
