#include "appforecast.h"

#include "ui_applistitem.h"
#include <QNetworkDiskCache>
#include <QDebug>
#include <QFileInfo>
#include <QTextStream>
#include <QDateTime>

AppForecast::AppForecast(QWidget* parent): QMainWindow(parent), ui(new Ui::AppList), settings("AppWatch", "AppForecast")
{
    ui->setupUi(this);
    ui->scrollArea->setProperty("FingerScrollable", true);
    ui->scrollArea->setProperty("FingerScrollBars", true);

//    connect(ui->actionRepository_filter, SIGNAL(triggered()), this, SLOT(showRepoChooser()));
//    connect(ui->action_Date_range, SIGNAL(triggered()), this, SLOT(showRangeChooser()));
    ui->actionRepository_filter->setVisible(false);
    ui->actionRating_filter->setVisible(false);
    ui->actionRepository_filter->setVisible(false);

    manager = new QNetworkAccessManager(this);
    qDebug() << settings.fileName();
    QNetworkDiskCache *diskCache = new QNetworkDiskCache(this);
    diskCache->setCacheDirectory(QFileInfo(settings.fileName()).absolutePath() + "/cacheDir");
    manager->setCache(diskCache);

    getData();

    connect(manager, SIGNAL(finished(QNetworkReply*)), this, SLOT(loadStat(QNetworkReply*)));
}


void AppForecast::getData()
{
    QString interval = settings.value("interval", QVariant("m")).toString();

    // do a request preferred from cache
    QNetworkRequest request(QUrl(QString("http://app.cache.rs/forecast")));
//    request.setAttribute(QNetworkRequest::CacheLoadControlAttribute, QNetworkRequest::AlwaysCache);
    request.setAttribute(QNetworkRequest::CacheLoadControlAttribute, QNetworkRequest::PreferCache);
    manager->get(request);
}


void AppForecast::loadStat(QNetworkReply* reply)
{
    QVariant fromCache = reply->attribute(QNetworkRequest::SourceIsFromCacheAttribute);
    qDebug() << "hist page from cache?" << fromCache.toBool();

    ////
    ////  Load graph data
    ////
    if (!reply->open(QIODevice::ReadOnly | QIODevice::Text)){
       return;
    }
    QTextStream in(reply);
    QString lastline = "";
    bool skipds = true; // set this to true to avoid referencing a datasourec before the first one
    int elemcount = 0;
    Ui::AppListItem* ali = new Ui::AppListItem();
    QWidget* item = new QWidget;
    ali->setupUi(item);
    ali->repo->setText("");
    ali->status->setText("");
    ui->verticalLayout->insertWidget(0, item);
    while (!in.atEnd()) {
        QString line = in.readLine();
        QStringList list = line.split(",");
        ali = new Ui::AppListItem();
        item = new QWidget;
        ali->setupUi(item);
        ali->date->setText(QDateTime::fromTime_t(list[0].toInt()).toString(Qt::SystemLocaleShortDate));
        ali->repo->setText("");
        ali->name->setText(list[1]);
        ali->version->setText(list[2].split("-")[0]);
        ali->rating->setText(list[3]+"/10");
        ali->status->setText("");
        int age = QDateTime::currentDateTime().toTime_t()- list[0].toInt();
        ui->verticalLayout->insertWidget(++elemcount, item);

//       AppListItem* ali = new AppListItem();
//       ali->ui->repo->setText("q");
    }
}
