#include <libosso.h>
#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <hildon/hildon.h>

#define GCONF_KEY "/apps/osso/applet/max-applets"

// extern "C"
osso_return_t execute(osso_context_t *osso, gpointer data, gboolean user_activated)
{
	GConfClient *client = gconf_client_get_default();

	int max_applets = gconf_client_get_int(client, GCONF_KEY, 0);
	if (max_applets == 0)
		max_applets = 7;


	GtkWidget *spin = hildon_number_editor_new(1, 20);
	hildon_number_editor_set_value(HILDON_NUMBER_EDITOR(spin), max_applets);

	GtkDialog *dialog = (GtkDialog*)gtk_dialog_new_with_buttons("Applet Count",
		GTK_WINDOW(data),
		GTK_DIALOG_DESTROY_WITH_PARENT,
		GTK_STOCK_OK,
		GTK_RESPONSE_ACCEPT,
		GTK_STOCK_CANCEL,
		GTK_RESPONSE_REJECT,
		0);

	GtkWidget *label = gtk_label_new("Number of statusbar applets:");

	GtkWidget *hbox = gtk_hbox_new(0, 0);

	gtk_container_add(GTK_CONTAINER(hbox), label);
	gtk_container_add(GTK_CONTAINER(hbox), spin);
	gtk_container_add(GTK_CONTAINER(dialog->vbox), hbox);

	gtk_widget_show(hbox);
	gtk_widget_show(spin);
	gtk_widget_show(label);

	if (gtk_dialog_run(dialog) == GTK_RESPONSE_ACCEPT)
	{
		gconf_client_set_int(client, GCONF_KEY,
			hildon_number_editor_get_value(HILDON_NUMBER_EDITOR(spin)),
			0);
	}

	gtk_widget_destroy(GTK_WIDGET(dialog));

	g_object_unref(G_OBJECT(client));

	return OSSO_OK;
}
