//
// anyRemote
// a bluetooth remote for your PC.
//
// Copyright (C) 2009 Mikhail Fedotov <anyremote@mail.ru>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
//

#include <fcntl.h>
#include <netdb.h> 
#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <unistd.h>

#include "common.h"
#include "utils.h"

//
// Frontend support (ganyremote/kanyremote) 
//

extern char tmp[MAXMAXLEN];

int sockfd_fe = 0;

int connectFrontEnd(int portno)
{
	int flags;
	sprintf(tmp, "connect to frontend >%d<",portno );
	logger("DEBUG", tmp);
	
	struct sockaddr_in serv_addr;
	struct hostent     *server;

	if (portno <= 0) {
		portno = 5050;
	}
	sockfd_fe = socket(AF_INET, SOCK_STREAM, 0);
	if (sockfd_fe < 0) {
		logger("ERROR", "opening socket for frontend");
		return EXIT_NOK;
	}
	
        if (-1 == (flags = fcntl(sockfd_fe, F_GETFL, 0)))
        	flags = 0;
     	fcntl(sockfd_fe, F_SETFL, flags | O_NONBLOCK);
	   
	server = gethostbyname("localhost");
	if (server == NULL) {
		return EXIT_NOK;
	}

	memset((void *) &serv_addr, 0, sizeof(serv_addr));
	serv_addr.sin_family = AF_INET;
	bcopy((char *)server->h_addr, (char *)&serv_addr.sin_addr.s_addr, server->h_length);
	serv_addr.sin_port = htons(portno);
	
	if (connect(sockfd_fe,(const struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) { 
		logger("ERROR", "connect socket for frontend");
		return EXIT_NOK;
	}
	logger("ERROR", "connected to frontend");
	return EXIT_OK;
}

int disconnectFrontEnd()
{
	if (sockfd_fe) { 
		close(sockfd_fe);
		sockfd_fe = 0;
	}
	return EXIT_OK;
} 

int sendToFrontEnd(char *buf)
{
	if (buf == NULL) {
		return EXIT_OK;
	}
	
	sprintf(tmp, "send to frontend >%s<", buf);
	logger("DEBUG", tmp);

	int n = write(sockfd_fe, buf,strlen(buf));
	if (n < 0) { 
		logger("ERROR", "ERROR writing to socket");
		return EXIT_NOK;
	}

	return EXIT_OK;
}

int readFromFrontEnd(char *buf, int size)
{
	//logger("INFO", "readFromFrontEnd");
	if (buf == NULL) {
		return EXIT_OK;
	}
 
        bzero(buf,size);
        int n = read(sockfd_fe,buf,size-1);
	if (n < 0) { 
		//logger("ERROR", "ERROR reading from socket");
		return EXIT_NOK;
	} else {
		*(buf+n) = '\0';
		if (n > 0) {
			sprintf(tmp, "Got from frontend (%d) >%s<", n, buf);
			logger("DEBUG", tmp);
			
			int i = 0;
			int k = 0;
			for (i=0;i<n;i++) {
				if (*(buf+i) != '\0') {
					if( i > k) {
						*(buf+k) = *(buf+i);
					} 
					k++;
				}
			}
			*(buf+k) = '\0';
			sprintf(tmp, "Got from frontend (%d) >%s<", n, buf);
			logger("DEBUG", tmp);
		}
	}
	
	return EXIT_OK;
}
