//	Advanced System UI
//	Copyright (c) 2010-2011 Brand Huntsman <brand.huntsman@gmail.com>

#include <time.h>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"
#include "hardware.h"
#include "dialog.h"
#include "dsme.h"

// open flashlight on fullscreen button
#include "flashlight.h"

 #include "widget_clock.h"

//////////////////////////////////////////////////////////////////////////

static double next_clock_refresh;
static unsigned keep_screen_lit;

void draw_clock_widget( unsigned force, int x, int y ){
	if(force){
		// background for all widgets is cleared by draw_window()
//		if(!drawing_popup_window){
//			// don't save values if drawing the popup window
//		}
	} else if(current_time >= next_clock_refresh){
		// widget background
		if(hw_device_locked){
			x_set_color(secondary_bg_color);
			x_fill_rectangle(x, y, 159, 99); // 160 wide on secure keypad
		} else if(use_minimal_ui){
			x_set_color(bg_color);
			x_fill_rectangle(x, y-25, 400, 150); // 400 wide on minimal UI (expanded)
		} else {
			x_set_color(bg_color);
			x_fill_rectangle(x, y, 199, 99); // 200 wide standard widget size
		}
	} else return;

	{
		time_t t = time(NULL);
		struct tm *tm = localtime(&t);
		char buffer[20];
		unsigned large_clock = (use_minimal_ui || drawing_popup_window ? 1 : 0);
		int x_center = x+(hw_device_locked ? 79 : (large_clock ? 200 : 99));

		strftime(buffer, sizeof(buffer), (cfg_clock_24h ? "%H:%M" : (cfg_clock_ampm ? "%l:%M %P" : "%l:%M")), tm); // time of day
		if(large_clock)
			draw_text((*buffer == ' ' ? &buffer[1] : buffer), 64, fg1_color, x_center, y-20, ALIGN_CENTER, ALIGN_TOP, 0);
		else
			draw_text((*buffer == ' ' ? &buffer[1] : buffer), 32, fg1_color, x_center, y+15, ALIGN_CENTER, ALIGN_TOP, 0);

		strftime(buffer, sizeof(buffer), "%A", tm); // long day of week
		if(large_clock)
			draw_text(buffer, 36, fg2_color, x_center, y+45, ALIGN_CENTER, ALIGN_TOP, 0);
		else
			draw_text(buffer, 18, fg2_color, x_center, y+47, ALIGN_CENTER, ALIGN_TOP, 0);

		strftime(buffer, sizeof(buffer), "%e %B", tm); // day and long month
		if(large_clock)
			draw_text((*buffer == ' ' ? &buffer[1] : buffer), 36, fg2_color, x_center, y+85, ALIGN_CENTER, ALIGN_TOP, 0);
		else
			draw_text((*buffer == ' ' ? &buffer[1] : buffer), 18, fg2_color, x_center, y+70, ALIGN_CENTER, ALIGN_TOP, 0);

		if(!drawing_popup_window)
			next_clock_refresh = current_time + (61 - tm->tm_sec);

		if(!use_minimal_ui && !popup_window_open){
			draw_tap_markers(x, y, 99, 1, 0); // short tap only
			keep_screen_lit = 0;
		}
	}
}

//////////////////////////////////////////////////////////////////////////

void draw_fullsreen_clock( unsigned force ){
	// force is not needed

	time_t t = time(NULL);
	struct tm *tm = localtime(&t);
	char buffer[20];

	// dialog background
	x_set_color(bg_color);
	x_fill_rectangle(0, 0, window.width, window.height);

	strftime(buffer, sizeof(buffer), "%A", tm); // long day of week
	draw_text(buffer, 48, fg2_color, window.width>>1, (window.height>>2)-32, ALIGN_CENTER, ALIGN_MIDDLE, 0);

	strftime(buffer, sizeof(buffer), (cfg_clock_24h ? "%H:%M" : (cfg_clock_ampm ? "%l:%M %P" : "%l:%M")), tm); // time of day
	draw_text((*buffer == ' ' ? &buffer[1] : buffer), 150, fg1_color, window.width>>1, window.height>>1, ALIGN_CENTER, ALIGN_MIDDLE, 0);

	strftime(buffer, sizeof(buffer), "%e %B", tm); // day and long month
	draw_text((*buffer == ' ' ? &buffer[1] : buffer), 48, fg2_color, window.width>>1, (window.height>>1)+(window.height>>2)+32, ALIGN_CENTER, ALIGN_MIDDLE, 0);

	// keep screen from blanking
	if(keep_screen_lit){
		x_set_color(red_color);
		x_fill_rectangle(window.width-22,2, 20,20);
		draw_masked_image(&im_brightness, window.width-21,3);
	}

	draw_tap_markers(0, 0, window.height-1, 0, 1); // long tap only

	// reset dialog refresh timer
	set_timer(&dialog_refresh_timer, (61 - tm->tm_sec));
}

static void click_fullsreen_clock( ){
	if(click.type == CLICK_HOLD){

		// highlight to indicate long press
		highlight_long_press(0, 0, window.width, window.height, 0);

	} else if(click.type == CLICK_LONG){

		// toggle keep screen lit mode
		keep_screen_lit = (keep_screen_lit ? 0 : 1);
		if(keep_screen_lit)
			dsme_pause_blanking(); // prevent screen from blanking
		else
			dsme_allow_blanking(); // allow screen to blank
		draw_fullsreen_clock(0);

	} else if(click.type == CLICK_DRAG && click.offset_y > 160){

		// close fullscreen clock
		highlight_selected_area(0, 0, window.width, window.height, 0); // hack
		dialog_close();

	}
}

static void keypress_fullscreen_clock( ){
	switch(keypress.keycode){
	case KEYCODE_ESCAPE:
		if(keypress.type == KEY_SHORT){
			// close fullscreen clock
			highlight_selected_area(0, 0, window.width, window.height, 0); // hack
			dialog_close();
		}
		break;
	case KEYCODE_FULLSCREEN:
		if(keypress.type == KEY_SHORT){
			// open flashlight
			flashlight_open();
			break;
		}
	default:
		if(!dpadlock_keypress_handler())
			if(!hw_device_locked) brv_keypress_handler();
				// ignore all other keys
		break;
	}
}

static void reset_fullscreen_clock( ){
	if(keep_screen_lit)
		dsme_allow_blanking(); // allow screen to blank
}

//////////////////////////////////////////////////////////////////////////

void clockFullscreen( ){
	// open dialog for fullscreen clock
	dialog_open(draw_fullsreen_clock, click_fullsreen_clock, keypress_fullscreen_clock, reset_fullscreen_clock, DLG_REDRAW_ON);
}

void click_clock_widget( ){
	if(click.type != CLICK_SHORT) return; // no long press or drag support

	if(throttle_taps(&dialog_throttle)) return;

		highlight_selected_area(widget_x, widget_y, 199, 99, 0);

		clockFullscreen();

	finalize_tap(dialog_throttle);
}

////////////////////////////////////////////////////////////////////////// WIDGET

s_widget widget_clock = {"Clock", "/apps/asui_state/cell_clock", HALF_WIDGET, draw_clock_widget, click_clock_widget, 0};
