#include <hildon/hildon-defines.h>
#include <libhildondesktop/libhildondesktop.h>
#include <libhildondesktop/statusbar-item.h>

#include <log-functions.h>
#include <libosso.h>
#include <osso-log.h>

#include <dbus/dbus.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdkpixbuf.h>

#include <gconf/gconf-client.h>

typedef enum e_icon_type {
	ICON_POWER, ICON_POWER_PRESSED,
	ICON_BATTERY_100, ICON_BATTERY_88, ICON_BATTERY_76, ICON_BATTERY_64, ICON_BATTERY_52, ICON_BATTERY_40, ICON_BATTERY_28, ICON_BATTERY_16, ICON_BATTERY_4,
	ICON_CHARGING_100, ICON_CHARGING_66, ICON_CHARGING_33,
	ICON_CHARGED
} e_icon_type;

typedef enum e_wifi_icon_type {
	ICON_WIFI_NONE, ICON_WIFI_DISCONNECTED, ICON_WIFI_CONNECTED
} e_wifi_icon_type;

typedef enum e_bluetooth_icon_type {
	ICON_BLUETOOTH_NONE, ICON_BLUETOOTH_ON, ICON_BLUETOOTH_CONNECTED, ICON_BLUETOOTH_ON_VISIBLE, ICON_BLUETOOTH_CONNECTED_VISIBLE
} e_bluetooth_icon_type;

typedef enum e_drain_icon_type {
	ICON_DRAIN_NONE, ICON_DRAIN_CHARGING, ICON_DRAIN_LOW, ICON_DRAIN_MEDIUM, ICON_DRAIN_HIGH, ICON_DRAIN_VERYHIGH
} e_drain_icon_type;

typedef enum e_cpu_icon_type {
	ICON_CPU_NONE, ICON_CPU_25, ICON_CPU_50, ICON_CPU_75, ICON_CPU_100
} e_cpu_icon_type;

typedef struct {

	////////////////////
	// main
	osso_context_t *osso;
	GtkWidget *icon, *button;
	unsigned press_timer;
	e_icon_type current_icon_type, new_icon_type;
	e_wifi_icon_type current_wifi_icon_type, new_wifi_icon_type;
	e_bluetooth_icon_type current_bluetooth_icon_type, new_bluetooth_icon_type;
	e_drain_icon_type current_drain_icon_type, new_drain_icon_type;
	e_cpu_icon_type current_cpu_icon_type, new_cpu_icon_type;

	////////////////////
	// gconf
	GConfClient *gconf_client;
	unsigned gconf_notify;
	unsigned use_battery;	// show battery status
	unsigned use_wifi;		// show wifi status - requires battery status
	unsigned use_bluetooth;	// show bluetooth status - requires battery status
	unsigned use_drain;		// show drain indicator
	unsigned use_cpu;		// show cpu usage

	unsigned mirror_wifi;
	unsigned mirror_bluetooth;

	unsigned force_battery_sounds;

	////////////////////
	// dbus
	DBusGConnection *connection; // system bus
	unsigned display_hooks;
	unsigned display_state;
	enum { LOWBATT_NONE, LOWBATT_16, LOWBATT_10, LOWBATT_4 } current_low_battery_state;

	////////////////////
	// battery
	unsigned battery_init_timer, battery_charging_timer;
	enum { BATTERY_DRAINING, BATTERY_CHARGING, BATTERY_AC } battery_status;
	unsigned battery_capacity, battery_initializing, battery_charging_cycle;

	unsigned wifi_state_timer, wifi_state_cycle;
	enum { WIFI_FLIGHT_MODE, WIFI_DISCONNECTED, WIFI_CONNECTING, WIFI_CONNECTED, WIFI_DISCONNECTING } wifi_status;

	enum { BLUETOOTH_OFF, BLUETOOTH_ON, BLUETOOTH_CONNECTED, BLUETOOTH_ON_VISIBLE, BLUETOOTH_CONNECTED_VISIBLE } bluetooth_status;

	////////////////////
	// BME
	int bme_fd; // BME socket
	unsigned bme_timer;

	////////////////////
	// cpu usage
	unsigned cpu_timer;
	unsigned cpu_ticks_per_second, cpu_ticks;
	double last_cpu_update;

} AsuiBatteryPluginPrivate;

//////////////////////////////////////////////////////////////////////////

void asui_battery_set_icon( AsuiBatteryPluginPrivate *p );
