//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include <string.h>

#include "main.h"
#include "config.h"
#include "battery.h"
#include "bme.h"
#include "cpu.h"

//////////////////////////////////////////////////////////////////////////

#define KEYNAME_PATH "/apps/asui"

static const char *conf_statusbar_battery_enable	= KEYNAME_PATH "/statusbar_battery_enable";
static const char *conf_statusbar_wifi_enable		= KEYNAME_PATH "/statusbar_wifi_enable";
static const char *conf_statusbar_bluetooth_enable	= KEYNAME_PATH "/statusbar_bluetooth_enable";
static const char *conf_statusbar_drain_enable		= KEYNAME_PATH "/statusbar_drain_enable";
static const char *conf_statusbar_cpu_enable		= KEYNAME_PATH "/statusbar_cpu_enable";

static const char *conf_statusbar_wifi_mirror		= KEYNAME_PATH "/statusbar_wifi_mirror";

static const char *conf_statusbar_force_battery_sounds = KEYNAME_PATH "/statusbar_force_battery_sounds";

//////////////////////////////////////////////////////////////////////////

static void config_key_change_callback( GConfClient *client, guint cnxn_id, GConfEntry *entry, gpointer userData ){
	AsuiBatteryPluginPrivate *p = (AsuiBatteryPluginPrivate *)userData;

	const gchar *keyname = gconf_entry_get_key(entry);
	if(keyname == NULL) return;
	if(strcmp(keyname, conf_statusbar_battery_enable)
	&& strcmp(keyname, conf_statusbar_wifi_enable)
	&& strcmp(keyname, conf_statusbar_bluetooth_enable)
	&& strcmp(keyname, conf_statusbar_drain_enable)
	&& strcmp(keyname, conf_statusbar_cpu_enable)
	&& strcmp(keyname, conf_statusbar_wifi_mirror)
	&& strcmp(keyname, conf_statusbar_force_battery_sounds)
	) return;

	unsigned use_drain = conf_get_bool(conf_statusbar_drain_enable);
	if(use_drain != p->use_drain){
		p->use_drain = use_drain;
		if(use_drain){
			bme_enable(p, 1); // also updates icon
		} else {
			bme_disable(p, 1);
			asui_battery_set_icon(p);
		}
	}

	unsigned use_cpu = conf_get_bool(conf_statusbar_cpu_enable);
	if(use_cpu != p->use_cpu){
		p->use_cpu = use_cpu;
		if(use_cpu){
			cpu_enable(p, 1); // also updates icon
		} else {
			cpu_disable(p, 1);
			asui_battery_set_icon(p);
		}
	}

	unsigned mirror_wifi = conf_get_bool(conf_statusbar_wifi_mirror);
	if(mirror_wifi != p->mirror_wifi){
		p->mirror_wifi = mirror_wifi;
		p->current_wifi_icon_type = ICON_WIFI_NONE; // force icon to be redrawn if it was active
		wifi_update_icon(p);
	}

	p->force_battery_sounds = conf_get_bool(conf_statusbar_force_battery_sounds);

	unsigned use_battery = conf_get_bool(conf_statusbar_battery_enable);
	if(use_battery != p->use_battery){
		p->use_battery = use_battery;
		if(use_battery){
			p->use_wifi = conf_get_bool(conf_statusbar_wifi_enable);
			p->use_bluetooth = conf_get_bool(conf_statusbar_bluetooth_enable);
			battery_enable(p, 1); // sets timer to initialize various battery values and updates icon when done
		} else {
			p->use_wifi = p->use_bluetooth = 0;
			battery_disable(p, 1);
			asui_battery_set_icon(p);
		}
	} else if(use_battery){
		unsigned use_wifi = conf_get_bool(conf_statusbar_wifi_enable);
		if(use_wifi != p->use_wifi){
			p->use_wifi = use_wifi;
			wifi_update_icon(p);
		}
		unsigned use_bluetooth = conf_get_bool(conf_statusbar_bluetooth_enable);
		if(use_bluetooth != p->use_bluetooth){
			p->use_bluetooth = use_bluetooth;
			bluetooth_update_icon(p);
		}
	}
}

//////////////////////////////////////////////////////////////////////////

unsigned config_init( AsuiBatteryPluginPrivate *p ){
	// initialize gconf
	if((p->gconf_client = gconf_client_get_default()) == NULL){
		ULOG_WARN("%s: can't connect to gconf\n", __FUNCTION__);
		return 0;
	}

	GError *error = NULL;
	gconf_client_add_dir(p->gconf_client, KEYNAME_PATH, GCONF_CLIENT_PRELOAD_NONE, &error);
	p->gconf_notify = gconf_client_notify_add(p->gconf_client, KEYNAME_PATH, config_key_change_callback, (void *)p, NULL, &error);

	p->use_battery = conf_get_bool(conf_statusbar_battery_enable);
	p->use_wifi = (p->use_battery ? conf_get_bool(conf_statusbar_wifi_enable) : 0);
	p->use_bluetooth = (p->use_battery ? conf_get_bool(conf_statusbar_bluetooth_enable) : 0);
	p->use_drain = conf_get_bool(conf_statusbar_drain_enable);
	p->use_cpu = conf_get_bool(conf_statusbar_cpu_enable);

	return 1;
}

void config_disconnect( AsuiBatteryPluginPrivate *p ){
	if(p->gconf_client){
		GError *error = NULL;
		gconf_client_remove_dir(p->gconf_client, KEYNAME_PATH, &error);
		if(p->gconf_notify) gconf_client_notify_remove(p->gconf_client, p->gconf_notify);
	}
}
