//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "main.h"
#include "ui.h"

//////////////////////////////////////////////////////////////////////////

typedef struct s_theme {
	char *filename, *listname;
	unsigned has_black, has_white;
	struct s_theme *next;
} s_theme;

static s_theme *themes;

static void default_theme_selector_callback( GtkComboBox *widget, gpointer data ){
	char *listname = gtk_combo_box_get_active_text(widget), *filename = NULL;
	s_theme *theme;
	for(theme = themes; theme != NULL; theme = theme->next)
		if(!strcmp(theme->listname, listname)){ filename = theme->filename; break; }
	if(filename) conf_set_string((const char *)data, filename);
}
static void new_theme_selector( const char *conf, char *name ){
	char *current_theme = conf_get_string(conf);
	int i = 0, current = -1;
	s_theme *theme;
	if(*current_theme == '\0') current_theme = NULL;

	// hbox
	GtkWidget *hbox = gtk_hbox_new(FALSE, 10);
	gtk_box_pack_start(GTK_BOX(section_content_box), hbox, FALSE, FALSE, 10);
	gtk_widget_show(hbox);
	// combo box
	GtkWidget *combo_box = gtk_combo_box_new_text();
	for(theme = themes; theme != NULL; theme = theme->next)
		if((conf == conf_theme_file_black && theme->has_black) || (conf == conf_theme_file_white && theme->has_white)){
			gtk_combo_box_append_text(GTK_COMBO_BOX(combo_box), theme->listname);
			if(current_theme == NULL){
				if(!strcmp(theme->filename, "default.bw")) current = i;
			} else if(!strcmp(theme->filename, current_theme)) current = i;
			i++;
		}
	if(current >= 0) gtk_combo_box_set_active(GTK_COMBO_BOX(combo_box), current);
	gtk_signal_connect(GTK_OBJECT(combo_box), "changed", GTK_SIGNAL_FUNC(default_theme_selector_callback), (void *)conf);
	gtk_box_pack_start(GTK_BOX(hbox), combo_box, FALSE, FALSE, 20);
	gtk_widget_show(combo_box);
	// label
	GtkWidget *label = gtk_label_new(name);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);
}

static unsigned add_theme( unsigned system, char *path, char *filename, unsigned has_black, unsigned has_white ){
	s_theme *theme = malloc(sizeof(s_theme));
	if(theme == NULL) return 0;

	unsigned file_length = strlen(filename)+1+(system ? 0 : strlen(path)+1);
	if((theme->filename = malloc(file_length)) == NULL){ free(theme); return 0; }

	unsigned list_length = strlen(filename)-(has_black+has_white+1)+1+(system ? 0 : 2);
	if((theme->listname = malloc(list_length)) == NULL){ free(theme->filename); free(theme); return 0; }

	if(system) strcpy(theme->filename, filename);
	else snprintf(theme->filename, file_length, "%s/%s", path, filename);

	char *p;
	snprintf(theme->listname, list_length, "%s%s", (system ? "" : "* "), filename);
	for(p = theme->listname; *p != '\0'; p++)
		if(*p == '-' || *p == '_') *p = ' ';

	theme->has_black = has_black;
	theme->has_white = has_white;
	theme->next = themes;
	themes = theme;
	return 1;
}

static void query_themes( unsigned system ){
	char *path = (system ? "/etc/asui-themes" : "/home/user/.asui-themes");
	DIR *themes_dir;

	if((themes_dir = opendir(path)) != NULL){
		struct dirent *file;
		while((file = readdir(themes_dir))){
			char *p = &file->d_name[strlen(file->d_name)];
			unsigned has_black = 0, has_white = 0;
			while(p >= file->d_name && *p != '.') p--;
			if(!strcmp(p, ".bw")) has_black = has_white = 1;
			else if(!strcmp(p, ".b")) has_black = 1;
			else if(!strcmp(p, ".w")) has_white = 1;
			else continue; // invalid

			if(!system || strcmp(file->d_name, "default.bw"))
				if(!add_theme(system, path, file->d_name, has_black, has_white))
					continue;
		}
		closedir(themes_dir);
	}
}

//////////////////////////////////////////////////////////////////////////

void ui_click_callback( GtkWidget *widget, gpointer data ){
	new_section_vbox("User Interface"); // add setting widgets to section_content_box

	// get list of files in /etc/asui-themes
	themes = NULL;
	add_theme(1, NULL, "default.bw", 1,1); // make sure built-in theme is always in the list
	query_themes(1); // get ASUI themes
	query_themes(0); // get user themes
	new_theme_selector(conf_theme_file_black, "black theme");
	new_theme_selector(conf_theme_file_white, "white theme");

	new_separator();

	new_message("The ASUI window can slide on to or off of the screen when opening or closing it.");
	new_checkbox(conf_window_slide_map, "slide on to screen when opening", NULL);
	new_checkbox(conf_window_slide_unmap, "slide off of screen when closing", NULL);

	new_separator();

	new_message("\"Touch screen and keys active\" notification can be displayed when the screen is turned on but wasn't locked.");
	new_checkbox(conf_tkactive_notifications, "show this notification", NULL);

	new_separator();

	new_checkbox(conf_service_size_unit, "show \"MB\" after service size", NULL);

	new_separator();

	new_message("Orange long tap markers are always displayed");
	new_checkbox(conf_short_tap_markers, "show blue markers for buttons that support short taps", NULL);

	new_separator();

	new_checkbox(conf_start_visible, "show ASUI window at startup", NULL);

	new_separator();

	new_message("When ALS value exceeds the white threshold the white theme is activated and returns to black theme when value drops below the black threshold.");
	new_uint_value(conf_threshold_black, "black threshold [n810 only]", 0, 999999999, NULL);
	new_uint_value(conf_threshold_white, "white threshold [n810 only]", 0, 999999999, NULL);

	new_separator();
}
