//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "main.h"
#include "statusbar.h"

//////////////////////////////////////////////////////////////////////////

static GtkWidget *statusbar_wifi_enable, *statusbar_wifi_mirror, *statusbar_bluetooth_enable;

static void toggle_checkbox_statusbar_battery( GtkToggleButton *widget, gpointer data ){
	unsigned state = (gtk_toggle_button_get_active(widget) == TRUE ? 1 : 0);
	conf_set_bool((const char *)data, state);
	gtk_widget_set_sensitive(statusbar_wifi_enable, (state ? TRUE : FALSE));
	gtk_widget_set_sensitive(statusbar_wifi_mirror, (state ? TRUE : FALSE));
	gtk_widget_set_sensitive(statusbar_bluetooth_enable, (state ? TRUE : FALSE));
}

//////////////////////////////////////////////////////////////////////////

void statusbar_click_callback( GtkWidget *widget, gpointer data ){
	new_section_vbox("Statusbar"); // add setting widgets to section_content_box

	new_message("The statusbar applet plays battery sounds at the current system volume level. Enabling this setting will always play battery sounds at maximum volume level.");
	new_checkbox(conf_statusbar_force_battery_sounds, "always play battery sounds", NULL);

	new_separator();

	new_message("The statusbar applet can be a simple power button to map ASUI or also show battery status.");
	GtkWidget *statusbar_battery = new_checkbox(conf_statusbar_battery_enable, "statusbar applet shows battery status", toggle_checkbox_statusbar_battery);

	new_separator();

	statusbar_wifi_enable = new_checkbox(conf_statusbar_wifi_enable, "show wifi status left of battery icon", NULL);
	statusbar_wifi_mirror = new_checkbox(conf_statusbar_wifi_mirror, "mirror wifi status right of battery icon", NULL);
	if(!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(statusbar_battery))){
		gtk_widget_set_sensitive(statusbar_wifi_enable, FALSE); // disable when battery unchecked
		gtk_widget_set_sensitive(statusbar_wifi_mirror, FALSE); // disable when battery unchecked
	}

	new_separator();

	statusbar_bluetooth_enable = new_checkbox(conf_statusbar_bluetooth_enable, "show bluetooth status right of battery icon", NULL);
	if(!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(statusbar_battery)))
		gtk_widget_set_sensitive(statusbar_bluetooth_enable, FALSE); // disable when battery unchecked

	new_separator();

	new_checkbox(conf_statusbar_drain_enable, "show drain rate indicator above battery icon", NULL);

	new_separator();

	new_checkbox(conf_statusbar_cpu_enable, "show cpu usage below battery/power icon", NULL);

	new_separator();
}
