#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>

#include <gtk/gtk.h>
#include <hildon/hildon.h>

#include <gconf/gconf-client.h>

extern unsigned is_770, is_800, is_810;

void asui_reload_settings( );
unsigned file_exists( const char *file );

extern GConfClient *gconf_client;

#define conf_get_bool(key) gconf_client_get_bool(gconf_client, key, (GError **)NULL)
#define conf_get_int(key) gconf_client_get_int(gconf_client, key, (GError **)NULL)
#define conf_get_string(key) gconf_client_get_string(gconf_client, key, (GError **)NULL)

#define conf_set_bool(key, value) {gconf_client_set_bool(gconf_client, key, value, (GError **)NULL); asui_reload_settings(); }
#define conf_set_int(key, value) {gconf_client_set_int(gconf_client, key, value, (GError **)NULL); asui_reload_settings(); }
#define conf_set_string(key, value) {gconf_client_set_string(gconf_client, key, value, (GError **)NULL); asui_reload_settings(); }

// statusbar
extern const char *conf_statusbar_battery_enable;
extern const char *conf_statusbar_wifi_enable;
extern const char *conf_statusbar_bluetooth_enable;
extern const char *conf_statusbar_drain_enable;
extern const char *conf_statusbar_cpu_enable;
extern const char *conf_statusbar_wifi_mirror;
extern const char *conf_statusbar_force_battery_sounds;

// battery
extern const char *conf_battery_idle_time;
extern const char *conf_memory_format;
extern const char *conf_swap_format;
extern const char *conf_temperature_F;
extern const char *conf_history_days;
extern const char *conf_track_usage_events;
// clock
extern const char *conf_clock_24h;
extern const char *conf_clock_ampm;
extern const char *conf_popup_duration;
extern const char *conf_popup_onmap;
extern const char *conf_popup_fullscreen;
extern const char *conf_popup_cooldown;
extern const char *conf_popup_noasui;
// brightness
extern const char *conf_brightness_enhanced;
extern const char *conf_brightness_allow_zero;
extern const char *conf_brightness_preset_1;
extern const char *conf_brightness_preset_2;
extern const char *conf_brightness_preset_3;
// WiFi
extern const char *conf_wifi_disconnect_fix;
// RBV keys
extern const char *conf_buttons_rotate;
extern const char *conf_buttons_brightness;
extern const char *conf_buttons_brightness_step;
extern const char *conf_buttons_volume;
extern const char *conf_buttons_volume_step;
// button modes
extern const char *conf_double_tap;
extern const char *conf_lock_and_close;
extern const char *conf_rotate_and_close;
extern const char *conf_split_lock_buttons;
extern const char *conf_buttons_dpad_short;
extern const char *conf_buttons_dpad_long;
extern const char *conf_buttons_lock1_short;
extern const char *conf_buttons_lock1_long;
extern const char *conf_buttons_lock2_short;
extern const char *conf_buttons_lock2_long;
// power button
extern const char *conf_power_enable_double;
extern const char *conf_power_action_single;
extern const char *conf_power_action_double;
extern const char *conf_power_longpress_shutdown;
extern const char *conf_power_blanks_when_locked;
extern const char *conf_power_unlock_key;
// device lock
extern const char *conf_secure_button;
extern const char *conf_secure_action;
extern const char *conf_secure_power_action_single;
extern const char *conf_secure_power_action_double;
extern const char *conf_secure_invert_keypad;
// user interface
extern const char *conf_tkactive_notifications;
extern const char *conf_service_size_unit;
extern const char *conf_short_tap_markers;
extern const char *conf_start_visible;
extern const char *conf_threshold_black;
extern const char *conf_threshold_white;
extern const char *conf_theme_file_black;
extern const char *conf_theme_file_white;
extern const char *conf_window_slide_unmap;
extern const char *conf_window_slide_map;
// alarm
extern const char *conf_alarm_duration;
extern const char *conf_alarm_volume_min;
extern const char *conf_alarm_volume_max;
extern const char *conf_alarm_volume_step;
// audio lock
extern const char *conf_audio_lock_blank_timeout;

extern GtkWidget *section_content_box;
void new_scrolling_vbox( GtkWidget *parent, GtkWidget **container, GtkWidget **content );
void new_separator( );
extern void (*section_cleanup_handler)( );
void new_section_vbox( char *name );
GtkWidget *new_message( char *message );
GtkWidget *new_button( GtkWidget *parent, char *name, void (*callback)(GtkWidget *widget, gpointer data), void *dta );
GtkWidget *new_button_right( GtkWidget *parent, char *name, void (*callback)(GtkWidget *widget, gpointer data), void *data );
GtkWidget *new_toggle_button( GtkWidget *parent, char *name, void (*callback)(GtkWidget *widget, gpointer data), void *data, gboolean state, gboolean expand, gboolean fill );
GtkWidget *new_toggle_button_right( GtkWidget *parent, char *name, void (*callback)(GtkWidget *widget, gpointer data), void *data, gboolean state );
GtkWidget *new_checkbox( const char *conf, char *label, void (*callback)(GtkToggleButton *widget, gpointer data) );
GtkWidget *new_selector( const char *conf, char *name, const char **items, void (*callback)(GtkComboBox *widget, gpointer data) );
GtkWidget *new_uint_value( const char *conf, char *name, unsigned min_value, unsigned max_value, void (*callback)(GObject *gobject, GParamSpec *arg1, gpointer user_data) );
