//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "main.h"
#include "brightness.h"

//////////////////////////////////////////////////////////////////////////

static GtkWidget *brightness_allow_zero;

static void toggle_checkbox_brightness_enhanced( GtkToggleButton *widget, gpointer data ){
	unsigned state = (gtk_toggle_button_get_active(widget) == TRUE ? 1 : 0);
	conf_set_bool((const char *)data, state);
	if(is_810) gtk_widget_set_sensitive(brightness_allow_zero, (state ? TRUE : FALSE));
}

static GtkWidget *preset_1_widget, *preset_2_widget, *preset_3_widget;
static unsigned preset_1, preset_2, preset_3;

static void change_preset_1( GObject *gobject, GParamSpec *arg1, gpointer user_data ){
	if(strcmp(arg1->name, "value")) return;
	int value;
	g_object_get(gobject, "value", &value, NULL);
	if(value >= (int)preset_2){
		hildon_number_editor_set_value((HildonNumberEditor *)preset_1_widget, preset_1);
	} else if(value >= 1 && value <= 127){
		conf_set_int((const char *)user_data, value);
		preset_1 = value;
	}
}
static void change_preset_2( GObject *gobject, GParamSpec *arg1, gpointer user_data ){
	if(strcmp(arg1->name, "value")) return;
	int value;
	g_object_get(gobject, "value", &value, NULL);
	if(value <= (int)preset_1 || value >= (int)preset_3){
		hildon_number_editor_set_value((HildonNumberEditor *)preset_2_widget, preset_2);
	} else if(value >= 1 && value <= 127){
		conf_set_int((const char *)user_data, value);
		preset_2 = value;
	}
}
static void change_preset_3( GObject *gobject, GParamSpec *arg1, gpointer user_data ){
	if(strcmp(arg1->name, "value")) return;
	int value;
	g_object_get(gobject, "value", &value, NULL);
	if(value <= (int)preset_2){
		hildon_number_editor_set_value((HildonNumberEditor *)preset_3_widget, preset_3);
	} else if(value >= 1 && value <= 127){
		conf_set_int((const char *)user_data, value);
		preset_3 = value;
	}
}

//////////////////////////////////////////////////////////////////////////

void brightness_click_callback( GtkWidget *widget, gpointer data ){
	new_section_vbox("Brightness"); // add setting widgets to section_content_box

	new_message("Brightness level will NOT be correct after unchecking this setting. You will need to open ASUI and change it.");
	GtkWidget *brightness_enhanced = new_checkbox(conf_brightness_enhanced, "use 127 brightness levels (else 5 levels)", toggle_checkbox_brightness_enhanced);

	new_separator();

	new_message("Enabling this setting allows brightness to be set to zero");
	brightness_allow_zero = new_checkbox(conf_brightness_allow_zero, "allow backlight to be turned off [n810 only]", NULL);
	if(!is_810 || !gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(brightness_enhanced)))
		gtk_widget_set_sensitive(brightness_allow_zero, FALSE); // disable when enhanced brightness is not enabled or device is not an N810

	new_separator();

	new_message("Presets for the device lock brightness toggle and the three buttons below the brightness slider.");
	preset_1 = conf_get_int(conf_brightness_preset_1);
	preset_2 = conf_get_int(conf_brightness_preset_2);
	preset_3 = conf_get_int(conf_brightness_preset_3);
	preset_1_widget = new_uint_value(conf_brightness_preset_1, "low preset", 1, 127, change_preset_1);
	preset_2_widget = new_uint_value(conf_brightness_preset_2, "medium preset", 1, 127, change_preset_2);
	preset_3_widget = new_uint_value(conf_brightness_preset_3, "high preset", 1, 127, change_preset_3);

	new_separator();
}
