typedef struct s_hw_memory {
	unsigned free;
	unsigned total;
} s_hw_memory;
typedef struct s_hw_swap {
	unsigned free;
	unsigned total;
} s_hw_swap;

typedef struct s_event_history {
	double timestamp;
	short unsigned state;
	struct s_event_history *next;
} s_event_history;

typedef struct s_hw_screen {
	unsigned visible;
	unsigned dimmed;
	double visible_time; // time when screen transitioned from !visible to visible
	unsigned locked;
	unsigned brightness_max;
	unsigned brightness_level;		// brightness level set by user
	unsigned brightness_current;	// current brightness level
	unsigned brightness_mismatch;	// current might not be same as level, keep checking with timer
	s_event_history *history_head, *history_tail;
} s_hw_screen;

typedef enum e_battery_status { BATTERY_DRAINING, BATTERY_CHARGING, BATTERY_AC } e_battery_status;
typedef struct s_battery_history {
	double timestamp;
	float capacity;
	struct s_battery_history *prev, *next;
} s_battery_history;
typedef struct s_hw_battery {
	unsigned initialize;
	e_battery_status status;
	float capacity;
	unsigned active_minutes;
	unsigned idle_minutes;
	float drain1;
	float drain24;
	unsigned hours1;
	unsigned hours24;
	s_battery_history *history_head, *history_tail;
	s_battery_history *charge_point;
	s_event_history *charger_history_head, *charger_history_tail;
} s_hw_battery;

typedef struct s_hw_governor {
	char *name;
	struct s_hw_governor *next;
} s_hw_governor;
typedef struct s_hw_dsp_clock {
	unsigned cpu;
	unsigned dsp;
	struct s_hw_dsp_clock *next;
} s_hw_dsp_clock;
typedef struct s_hw_cpu {
	unsigned nr_governors;
	s_hw_governor *governor_list;
	s_hw_governor *current_governor;
	unsigned frequency;
	unsigned usage;
	unsigned nr_dsp_clocks;
	s_hw_dsp_clock *dsp_clocks;
	unsigned dsp_frequency; // non-zero when enabled
} s_hw_cpu;

#define BLUETOOTH_NAME_LIMIT 25
typedef struct s_hw_bluetooth {
	unsigned enabled;
	unsigned visible;
	char *name;
	unsigned nr_devices;	// number of connected devices
	unsigned headset;		// headset connected
	s_event_history *history_head, *history_tail;
} s_hw_bluetooth;

typedef struct s_hw_gps {
	unsigned enabled;
	s_event_history *history_head, *history_tail;
} s_hw_gps;

#define WIFI_NAME_LIMIT 25
#define WIFI_ADDRESS_LIMIT 15
typedef enum e_hw_wifi_state { WIFI_DISCONNECTED = 0, WIFI_CONNECTING, WIFI_CONNECTED, WIFI_DISCONNECTING } e_hw_wifi_state;
typedef struct s_hw_wifi {
	unsigned enabled;
	char *name;
	char *address;
	e_hw_wifi_state state;
	int disconnect_unfix;
	s_event_history *history_head, *history_tail;
} s_hw_wifi;

typedef struct s_hw_sensors {
	float temperature;
	unsigned light;
	unsigned headphones;
} s_hw_sensors;

typedef struct s_hw_usb {
	unsigned mode;
	unsigned connected;
} s_hw_usb;

//////////////////////////////////////////////////////////////////////////

#define HWIS_MCE_DISPLAY (1<<0)
#define HWIS_MCE_LOCK (1<<1)
#define HWIS_MCE_FLIGHT (1<<2)
#define HWIS_BME_CHARGER (1<<3)
#define HWIS_BME_MAX (1<<4)
#define HWIS_BME_CAPACITY (1<<5)
#define HWIS_BME_ACTIVE (1<<6)
#define HWIS_BLUETOOTH_MODE (1<<7)
#define HWIS_BLUETOOTH_NAME (1<<8)
#define HWIS_BLUETOOTH_DEVICES (1<<9)
#define HWIS_BLUETOOTH_HEADSET (1<<10)
#define HWIS_WIFI_MODE (1<<11)
#define HWIS_WIFI_STATE (1<<12)
extern unsigned hw_initialized;

#define HW_BRIGHTNESS (1<<0)
#define HW_VOLUME (1<<1)
#define HW_MEMORY (1<<2)
#define HW_FLIGHT_MODE (1<<3)
#define HW_BATTERY (1<<4)
#define HW_CPU (1<<5)
#define HW_CPU_USAGE (1<<6)
#define HW_BLUETOOTH (1<<7)
#define HW_GPS (1<<8)
#define HW_WIFI (1<<9)
#define HW_TEMPERATURE (1<<10)
#define HW_LIGHT (1<<11)
#define HW_VOLUME_OUTPUT (1<<12)
#define HW_THEME (1<<13)
#define HW_USB (1<<14)
#define HW_KEY_REPEAT (1<<15)
#define HW_SCREEN_STAYS_LIT (1<<16)
#define HW_SCREEN_AUTOLOCK (1<<17)
#define HW_ROTATION (1<<18)
#define HW_THEME_FILE (1<<19)
extern unsigned hw_changes;

extern int hw_volume;
extern s_hw_memory hw_memory;
extern s_hw_swap hw_swap;
extern s_hw_screen hw_screen;
extern unsigned hw_flight_mode, hw_entering_flight_mode;
extern unsigned hw_device_locked;
extern s_hw_battery hw_battery;
extern s_hw_cpu hw_cpu;
extern s_hw_bluetooth hw_bluetooth;
extern s_hw_gps hw_gps;
extern s_hw_wifi hw_wifi;
extern s_hw_sensors hw_sensors;
extern s_hw_usb hw_usb;
extern unsigned hw_audio_lock, hw_key_repeat, hw_screen_stays_lit, hw_screen_autolock;

extern double last_hw_refresh;

extern const char *touchscreen_control, *keypad_control;

//////////////////////////////////////////////////////////////////////////

int get_file_value( const char *filename );
void hw_new_event( const char *label, s_event_history **head, s_event_history **tail, unsigned state );

void brightness_init( );
void hw_query_brightness( );
void hw_query_brightness_with_delay( );
void hw_set_brightness( unsigned level, unsigned update );

#ifdef DEBUG
 void debug_tklock_state( const char *section );
#else
 #define debug_tklock_state(section) {}/* do nothing */
#endif
void hw_init_cp_screen_settings( );
void hw_restore_cp_screen_settings( );
void mce_wake_screen( );
void mce_dim_screen( unsigned expect );
void mce_blank_screen( );
void mce_lock_and_blank_screen( );
void mce_lock_screen( unsigned expect );
void mce_unlock_screen( );
void hw_lock_screen( );
void hw_unlock_screen( );
void hw_lock_keys( );
void hw_unlock_keys( );
void mce_normal_mode( );
void mce_flight_mode( );
void mce_lock_device( );
void mce_unlock_device( );
void mce_reboot( );
void mce_shutdown( );

void hw_query_battery( unsigned flush );

void hw_set_governor( s_hw_governor *governor );
void hw_set_dsp_ratio( unsigned ratio );

void hw_set_bluetooth( unsigned enable );
void hw_set_bluetooth_visible( unsigned visible );
void hw_bluetooth_open_search( );

// gps...

int  hw_wifi_get_name( char *iap );
void hw_wifi_get_ipinfo( );
void hw_wifi_open_selector( );
void hw_wifi_auto_connect( );
void hw_wifi_disconnect( );

void hw_query_temperature( );
void hw_query_als( );
void hw_query_headphones( );

void hw_query_usb( );
void hw_toggle_usb_mode( );

void hw_init( );
void hw_refresh_cpu( );
void hw_refresh( );
void hw_refresh_popup( );
