#ifndef _WINDOW_H_
#include "window.h"
#endif

extern unsigned tick_i;

//////////////////////////////////////////////////////////////////////////

void draw_masked_image( s_image *image, int x, int y );
void draw_themed_image( s_image *image, int x, int y );

void draw_services_indicator( int status, int x, int y, unsigned height );
void draw_hardware_indicator( int status, int x, int y );

void draw_tap_markers( int x, int y, int height, unsigned short_tap, unsigned long_tap );

void draw_scrollbar( s_image *image, int x, int y, unsigned position, unsigned min, unsigned max );
unsigned click_scrollbar( int x, unsigned min, unsigned max );
void draw_step_buttons( int x, int y, unsigned long_decrement, unsigned long_increment );

void highlight_long_press( int x, int y, int width, int height, unsigned secondary );
void unhighlight_long_press( );

void highlight_selected_area( int x, int y, int width, int height, unsigned secondary );
void unhighlight_selected_area( );

void init_ticks( int x, int y, XColor *color );
void draw_tick( );

void draw_rss( unsigned size, int x, int y );
