//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"

//////////////////////////////////////////////////////////////////////////

#define NAME_BASELINE 17
#define VOLUME_YOFF 21
#define VOLUME_WIDTH 44
#define VOLUME_XOFF (80-VOLUME_WIDTH)/2
void draw_sound_indicator( int x, int y, const char *conf, char *name ){
	// button box
	x_set_color(line1_color);
	x_draw_rectangle(x+7,y+2, 65,21);

	x_set_style(2, LineOnOffDash);
	// volume level
	unsigned level = conf_get_int(conf);
	if(level){
		x_set_color(fg1_color);
		x_draw_line(x+VOLUME_XOFF,y+VOLUME_YOFF, x+VOLUME_XOFF+(VOLUME_WIDTH/2)*level,y+VOLUME_YOFF);
	}
	x_set_style(2, LineSolid);
	// empty volume bar
	if(level < 2){
		x_set_color(line1_color);
		x_draw_line(x+VOLUME_XOFF+(VOLUME_WIDTH/2)*level,y+VOLUME_YOFF, x+VOLUME_XOFF+VOLUME_WIDTH,y+VOLUME_YOFF);
	}
	x_reset_style();

	draw_text(name, 16, fg2_color, x+40, y+NAME_BASELINE, ALIGN_CENTER, ALIGN_BASELINE, 0);

	draw_tap_markers(x+6, y, 25, 1, 0); // short tap only
}

void draw_sounds_button( unsigned force, int x, int y ){
	if(force){
		// background for all buttons is cleared by draw_window()
//		sounds_button_page = primary_widgets;
//	} else if(/* condition */){
//		// button background
//		x_set_color(secondary_bg_color);
//		x_fill_rectangle(x, y, 80, 80);
	} else return;

	draw_sound_indicator(x, y+1,  conf_system_alert_volume, "system");
	draw_sound_indicator(x, y+27, conf_keypad_volume, "keys");
	draw_sound_indicator(x, y+53, conf_touchscreen_volume, "touch");
}

//////////////////////////////////////////////////////////////////////////

void click_sounds_button( ){
	if(click.type != CLICK_SHORT) return;

	if(click.y >= 53){
		// touchscreen volume
		highlight_selected_area(widget_x, widget_y+53, 80,26, 1);
		unsigned volume = conf_get_int(conf_touchscreen_volume) + 1;
		if(volume > 2) volume = 0;
		conf_set_int(conf_touchscreen_volume, volume);
	} else if(click.y >= 27){
		// keypad volume
		highlight_selected_area(widget_x, widget_y+27, 80,26, 1);
		unsigned volume = conf_get_int(conf_keypad_volume) + 1;
		if(volume > 2) volume = 0;
		conf_set_int(conf_keypad_volume, volume);
	} else {
		// system alert volume
		highlight_selected_area(widget_x, widget_y+1, 80,26, 1);
		unsigned volume = conf_get_int(conf_system_alert_volume) + 1;
		if(volume > 2) volume = 0;
		conf_set_int(conf_system_alert_volume, volume);
	}

	// redraw button
	x_set_color(secondary_bg_color);
	x_fill_rectangle(widget_x, widget_y, 80, 80);
	draw_sounds_button(1, widget_x, widget_y);
	x_flush();
}

////////////////////////////////////////////////////////////////////////// BUTTON

s_button button_sounds = {"*sounds", "/apps/asui_state/bcell_sounds", draw_sounds_button, click_sounds_button, 0};
