//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include <stdlib.h>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"

//////////////////////////////////////////////////////////////////////////

void draw_settings_button( unsigned force, int x, int y ){
	if(force){
		// background for all buttons is cleared by draw_window()
//	} else if(/* condition */){
//		// button background
//		x_set_color(secondary_bg_color);
//		x_fill_rectangle(x, y, 80, 80);
	} else return;

	unsigned cx = x+40, cy = y+40;

	draw_text("settings", 16, fg2_color, cx, cy+6, ALIGN_CENTER, ALIGN_BASELINE, 0);

	draw_tap_markers(x, y, 80, 1, 0); // short tap only
}

//////////////////////////////////////////////////////////////////////////

void click_settings_button( ){
	if(click.type != CLICK_SHORT) return;

	highlight_selected_area(widget_x, widget_y, 80,80, 1); // highlight removed when window is redrawn
	if(file_exists("/root/.asui-settings-test"))
		system("/root/.asui-settings-test &"); // test
	else
		system("/usr/bin/advanced-systemui-settings &"); // release
	window_unmap(1);
}

////////////////////////////////////////////////////////////////////////// BUTTON

s_button button_settings = {"settings", "/apps/asui_state/bcell_settings", draw_settings_button, click_settings_button, 0};
