//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <esd.h>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"

////////////////////////////////////////////////////////////////////////// GLOBALS

unsigned screenshot_waiting;
s_timer screenshot_timer;

//////////////////////////////////////////////////////////////////////////

// this requires the screenshot-tool package to be installed

unsigned screenshot_tool_installed;

void draw_screenshot_button( unsigned force, int x, int y ){
	if(force){
		// background for all buttons is cleared by draw_window()
//	} else if(/* condition */){
//		// button background
//		x_set_color(secondary_bg_color);
//		x_fill_rectangle(x, y, 80, 80);
	} else return;

	int w = draw_text("screenshot", 12, fg2_color, x+39, y+10, ALIGN_CENTER, ALIGN_TOP, 0)>>1;

	if(file_exists("/usr/bin/screenshot-tool")){
		screenshot_tool_installed = 1;

		// long tap indicator
		x_set_color(secondary_selection_color);
		x_draw_line(x+40-w, y+22, x+40+w, y+22);

		char buffer[10];
		snprintf(buffer, sizeof(buffer), "%u", cfg_screenshot_delay);
		draw_text(buffer, 16, fg1_color, x+39, y+39, ALIGN_CENTER, ALIGN_MIDDLE, 0);

		// draw delay buttons
		if(cfg_screenshot_delay > MIN_SCREENSHOT_DELAY) x_set_color(stepper_color); else x_set_color(line2_color);
		x_draw_line(x+11,y+59, x+27,y+59); // minus
		if(cfg_screenshot_delay < MAX_SCREENSHOT_DELAY) x_set_color(stepper_color); else x_set_color(line2_color);
		x_draw_line(x+51,y+59, x+67,y+59); // plus horizontal
		x_draw_line(x+59,y+51, x+59,y+67); // plus vertical
		// circular button borders
		x_set_color(line2_color);
		x_set_style(1, LineOnOffDash); // dotted line
		x_draw_ellipse(x+ 4, y+44, 29,30); // minus
		x_draw_ellipse(x+44, y+44, 29,30); // plus
		x_reset_style();
	} else {
		screenshot_tool_installed = 0;

		draw_text("tool", 12, fg2_color, x+39, y+36, ALIGN_CENTER, ALIGN_BOTTOM, 0);
		draw_text("not installed", 12, fg1_color, x+39, y+53, ALIGN_CENTER, ALIGN_MIDDLE, 0);
	}
}

//////////////////////////////////////////////////////////////////////////

void take_screenshot( ){
	// use /usr/bin/screenshot-tool to take shot
	time_t t = time(NULL);
	struct tm *tm = localtime(&t);
	char filename[75], command[200];
	snprintf(filename, sizeof(filename), "/home/user/MyDocs/.images/screenshot-%d%02d%02d-%02d%02d%02d.png",
											tm->tm_year + 1900, tm->tm_mon + 1, tm->tm_mday, tm->tm_hour, tm->tm_min, tm->tm_sec);
	snprintf(command, sizeof(command), "/usr/bin/screenshot-tool -q %s && chown user %s", filename, filename);
	system(command);

	// use esd to play sound after shot is taken
	esd_play_file("com.qzx.asui",
					(file_exists("/usr/share/sounds/camera-capture-image.wav")
						? "/usr/share/sounds/camera-capture-image.wav"
						: "/usr/share/sounds/ui-general_warning.wav"),
					1);

	screenshot_waiting = 0;
}

void click_screenshot_button( ){
	if(!screenshot_tool_installed) return;

	if(click.type == CLICK_HOLD){

		// highlight to indicate long press
		highlight_long_press(widget_x, widget_y, 80,80, 1);

	} else if(click.type == CLICK_LONG){

		highlight_selected_area(widget_x, widget_y, 80,80, 1);

		set_timer(&screenshot_timer, cfg_screenshot_delay);
		screenshot_waiting = 1;

		unhighlight_selected_area();

	} else if(click.type == CLICK_SHORT && click.y > 39){

		if(click.x > 39){
			// increment

			if(cfg_screenshot_delay < MAX_SCREENSHOT_DELAY){
				cfg_screenshot_delay++;
				conf_set_int(conf_screenshot_delay, cfg_screenshot_delay);
			}

		} else {
			// decrement

			if(cfg_screenshot_delay > MIN_SCREENSHOT_DELAY){
				cfg_screenshot_delay--;
				conf_set_int(conf_screenshot_delay, cfg_screenshot_delay);
			}

		}

		// redraw button
		x_set_color(secondary_bg_color);
		x_fill_rectangle(widget_x, widget_y, 80, 80);
		draw_screenshot_button(1, widget_x, widget_y);
		x_flush();

	}
}

////////////////////////////////////////////////////////////////////////// BUTTON

s_button button_screenshot = {"screenshot", "/apps/asui_state/bcell_screenshot", draw_screenshot_button, click_screenshot_button, 0};
