//	Advanced System UI
//	Copyright (c) 2010-2011 Brand Huntsman <brand.huntsman@gmail.com>

#include <unistd.h>

#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"
#include "services.h"
#include "hardware.h"

//////////////////////////////////////////////////////////////////////////

void draw_flight_mode_button( unsigned force, int x, int y ){
	if(force){
		// background for all buttons is cleared by draw_window()
		flightmode_button_page = primary_widgets;
	} else if(hw_changes & HW_FLIGHT_MODE){
		// button background
		x_set_color(secondary_bg_color);
		x_fill_rectangle(x, y, 80, 80);
	} else return;

	unsigned cx = x+40, cy = y+40;

	draw_text("NORMAL", 12, (hw_flight_mode ? fg1_color : bold_color), cx+1, cy-9, ALIGN_CENTER, ALIGN_BASELINE, 0);
	draw_text("FLIGHT", 12, (hw_flight_mode ? bold_color : fg1_color), cx,   cy+18, ALIGN_CENTER, ALIGN_BASELINE, 0);
	x_set_color(line1_color);
	if(hw_flight_mode){
		x_draw_rectangle(cx-32, cy-9-15, 64,19); // button around NORMAL

		x_draw_line(cx-1, cy-1, cx+1, cy-1); // arrow pointing up
		x_draw_line(cx-2, cy+0, cx+2, cy+0);
		x_draw_line(cx-3, cy+1, cx+3, cy+1);
		x_draw_line(cx-4, cy+2, cx+4, cy+2);
		x_draw_line(cx-5, cy+3, cx+5, cy+3);
		x_draw_line(cx-6, cy+4, cx+6, cy+4);

		draw_tap_markers(x+8, y+16, 20, 1, 0); // short tap only
	} else {
		x_draw_rectangle(cx-32, cy+18-14, 64,19); // button around FLIGHT

		x_draw_line(cx-6, cy-5, cx+6, cy-5); // arrow pointing down
		x_draw_line(cx-5, cy-4, cx+5, cy-4);
		x_draw_line(cx-4, cy-3, cx+4, cy-3);
		x_draw_line(cx-3, cy-2, cx+3, cy-2);
		x_draw_line(cx-2, cy-1, cx+2, cy-1);
		x_draw_line(cx-1, cy-0, cx+1, cy-0);

		draw_tap_markers(x+8, y+44, 20, 1, 1); // short and long taps
	}
}

//////////////////////////////////////////////////////////////////////////

static s_tap_throttler flight_throttle;

void click_flight_mode_button( ){
	if(click.type == CLICK_HOLD){

		if(!hw_flight_mode){
			// highlight to indicate long press
			highlight_long_press(widget_x, widget_y, 80,80, 1);
		}

	} else if(click.type == CLICK_SHORT){

		if(throttle_taps(&flight_throttle)) return;

		highlight_selected_area(widget_x, widget_y, 80,80, 1);

		// toggle between normal and offline modes
		if(hw_flight_mode)
			mce_normal_mode();
		else
			mce_flight_mode(1);

		finalize_tap(flight_throttle);

		// redraw button
		draw_flight_mode_button(0, widget_x, widget_y);
		hw_changes &= ~HW_FLIGHT_MODE;
		x_flush();

		// signals will cause effected widgets to be redrawn

	} else if(click.type == CLICK_LONG){

		if(!hw_flight_mode){
			highlight_selected_area(widget_x, widget_y, 80,80, 1); // highlight removed when window is redrawn

			// enter flight mode and stop all related services
			mce_flight_mode(1);
			usleep(100000);
			svc_init_gps(SVC_STOP);
			svc_init_bluetooth(SVC_STOP, 0);
			svc_init_wifi(SVC_STOP, 0);
			svc_init_ssh(SVC_STOP, 1);
			svc_init_vpn(SVC_STOP);

			// redraw window
			draw_window(0);
		}

		// no long press to enter normal mode

	}
}

////////////////////////////////////////////////////////////////////////// BUTTON

s_button button_flight_mode = {"*flight", "/apps/asui_state/bcell_flight_mode", draw_flight_mode_button, click_flight_mode_button, 0};
