#define _WINDOW_H_

#include <X11/Xlib.h>

typedef enum e_orientation { O_LANDSCAPE, O_PORTRAIT, O_LANDSCAPE_INV, O_PORTRAIT_INV } e_orientation;

typedef struct s_window {
	Display *display;
	Window root_window;
	int screen;
	Visual *visual;
	int depth;
	Colormap colormap;
	int x, y;
	unsigned width, height;
	Window window;
	GC gc;
	unsigned is_mapped;
	unsigned supports_rotation, xrr_event_base;
	e_orientation orientation;
	unsigned has_focus;
} s_window;

extern s_window window;

extern XColor *bg_color, *secondary_bg_color, *line1_color, *line2_color, *fg1_color, *fg2_color, *bold_color, *rotation_color;
extern XColor *gray_color, *yellow_color, *green_color, *red_color, *blue_color;
extern XColor *scrollbar_color, *scroller_color, *selection_color, *secondary_selection_color, *button_color, *stepper_color;

typedef struct s_image {
	Pixmap black_pixmap, white_pixmap, mask;
	unsigned width, height;
} s_image;

extern s_image im_reboot, im_shutdown;
extern s_image im_volume, im_brightness;
extern s_image im_portrait, im_portrait_inv, im_landscape_inv;

extern unsigned black_theme, theme_is_dark;

extern int blank_fd, popup_fd;
extern unsigned blank_window_open, popup_window_open, drawing_popup_window;
extern double popup_window_open_time;

//////////////////////////////////////////////////////////////////////////

void window_reload( unsigned init );

int window_init( );

void window_set_theme( unsigned white_theme );
void window_auto_set_theme( unsigned initialize );

void window_map( unsigned slide );
void window_unmap( unsigned slide );

void window_slide( int x, int y );

void window_close( unsigned terminate );

void rotate_screen( e_orientation new_orientation, unsigned keep_mapped );
void update_orientation( XEvent *event );
int check_orientation( );

void window_open_blank( );
void window_close_blank( );
unsigned window_blank_events( );

void draw_popup_window( );
void window_open_popup( );
void window_close_popup( );
void window_popup_events( );

#define x_set_color(color) XSetForeground(window.display, window.gc, color->pixel)
#define x_set_style(width, style) XSetLineAttributes(window.display, window.gc, width, style, CapButt, JoinMiter)
#define x_reset_style() XSetLineAttributes(window.display, window.gc, 1, LineSolid, CapButt, JoinMiter)
#define x_draw_point(x, y) XDrawPoint(window.display, window.window, window.gc, x, y)
#define x_draw_line(x1, y1, x2, y2) XDrawLine(window.display, window.window, window.gc, x1, y1, x2, y2)
#define x_draw_rectangle(x, y, w, h) XDrawRectangle(window.display, window.window, window.gc, x, y, w, h)
#define x_fill_rectangle(x, y, w, h) XFillRectangle(window.display, window.window, window.gc, x, y, w, h)
#define x_draw_ellipse(x, y, w, h) XDrawArc(window.display, window.window, window.gc, x, y, w, h, 0, 360*64)
#define x_fill_ellipse(x, y, w, h) XFillArc(window.display, window.window, window.gc, x, y, w, h, 0, 360*64)
#define x_flush() XFlush(window.display)
