#!/bin/sh

cd /opt/scratchbox/users/test/home/test/advanced-systemui/

function echo_msg(){
	echo -e "\033[36;2m$1\033[0m"
}

if [ "$1" = "tar" ]; then
	cd ..
	tar -X advanced-systemui/.excludes -jcvf advanced-systemui.tar.bz2 advanced-systemui/
	echo_msg "Moving source code to web directory for upload..."
	install -o asd -g apache -m 640 advanced-systemui.tar.bz2 /home/http/html/asui/_download/
elif [ "$1" = "deb" ]; then
	cd ..
	echo_msg "Moving deb file to tmp repo..."
	mv advanced-systemui_*_armel.deb repo/dists/diablo/free/binary-armel/advanced-systemui/
	echo_msg "cd ../repo ; dpkg-scanpackages dists/diablo/free/binary-armel /dev/null | gzip -9c > dists/diablo/free/binary-armel/Packages.gz ; cd ../advanced-systemui"
elif [ "$1" = "repo" ]; then
	cd ..
	echo_msg "Moving deb file to local repo..."
	install -o asd -g apache -m 640 repo/dists/diablo/free/binary-armel/Packages.gz /home/http/html/asui/repo/dists/diablo/free/binary-armel/
	install -o asd -g apache -m 640 repo/dists/diablo/free/binary-armel/advanced-systemui/*.deb /home/http/html/asui/repo/dists/diablo/free/binary-armel/advanced-systemui
	rm -f repo/dists/diablo/free/binary-armel/advanced-systemui/*.deb
elif [ "$1" = "web" ]; then
	echo_msg "Moving asui script to web directory for upload..."
	install -o asd -g apache -m 640 scripts/asui.sh /home/http/html/asui/_download/
	echo_msg "Moving themes to web directory for upload..."
	mkdir asui-themes-test
	cp themes/* asui-themes-test/
	tar -czvf asui-themes-test.tar.gz asui-themes-test/
	install -o asd -g apache -m 640 asui-themes-test.tar.gz /home/http/html/asui/_download/
	rm -rf asui-themes-test asui-themes-test.tar.gz
	if [ -f "advanced-systemui-test" ]; then
		echo_msg "Moving test binary to web directory for upload..."
		install -o asd -g apache -m 640 advanced-systemui-test /home/http/html/asui/_download/
	fi
	if [ -f "advanced-systemui-debug" ]; then
		echo_msg "Moving debug binary to web directory for upload..."
		install -o asd -g apache -m 640 advanced-systemui-debug /home/http/html/asui/_download/
	fi
	if [ -f "settings/advanced-systemui-settings" ]; then
		echo_msg "Moving asui-settings test binary to web directory for upload..."
		install -o asd -g apache -m 640 settings/advanced-systemui-settings /home/http/html/asui/_download/asui-settings-test
	fi
	if [ -f "statusbar/libasui-battery.so" ]; then
		echo_msg "Moving statusbar test applet to web directory for upload..."
		mkdir asui-statusbar-test
		cp statusbar/libasui-battery.so statusbar/asui-battery.desktop statusbar/icons/*.png asui-statusbar-test/
		tar czvf asui-statusbar-test.tar.gz asui-statusbar-test/
		install -o asd -g apache -m 640 asui-statusbar-test.tar.gz /home/http/html/asui/_download/
		rm -rf asui-statusbar-test asui-statusbar-test.tar.gz
	fi
elif [ "$1" = "n810" ]; then
	echo_msg "Transfering asui script to n810..."
	scp scripts/asui.sh n810:/usr/bin/asui
	if [ -f "advanced-systemui-test" ]; then
		echo_msg "Transfering test binary to n810..."
		scp advanced-systemui-test n810:/root/.advanced-systemui-test
		ssh n810 chmod 755 /root/.advanced-systemui-test
	fi
	if [ -f "advanced-systemui-debug" ]; then
		echo_msg "Transfering debug binary to n810..."
		scp advanced-systemui-debug n810:/root/.advanced-systemui-debug
		ssh n810 chmod 755 /root/.advanced-systemui-debug
	fi
	if [ -f "settings/advanced-systemui-settings" ]; then
		echo_msg "Transfering asui-settings test binary to n810..."
		scp settings/advanced-systemui-settings n810:/root/.asui-settings-test
		ssh n810 chmod 755 /root/.asui-settings-test
	fi
	if [ -f "statusbar/libasui-battery.so" ]; then
		echo_msg "Transfering statusbar test applet to n810..."
		scp statusbar/libasui-battery.so n810:/usr/lib/hildon-desktop/
		scp statusbar/asui-battery.desktop n810:/usr/share/applications/hildon-status-bar/
		ssh n810 chmod 644 /usr/lib/hildon-desktop/libasui-battery.so /usr/share/applications/hildon-status-bar/asui-battery.desktop
	fi
elif [ "$1" = "icons" ]; then
	echo_msg "Transfering desktop and statusbar icons to n810..."
	scp scripts/asui_icon.png scripts/asui_settings_icon.png n810:/usr/share/icons/hicolor/64x64/hildon/
	scp statusbar/icons/* n810:/usr/share/icons/hicolor/40x40/hildon/
	ssh n810 gtk-update-icon-cache -f /usr/share/icons/hicolor
elif [ "$1" = "themes" ]; then
	echo_msg "Transfering themes to n810..."
	scp themes/* n810:/etc/asui-themes/
	ssh n810 chmod 644 /etc/asui-themes/*
elif [ "$1" = "release" ]; then
	if [ "$2" != "" ]; then
		echo_msg "Transfering $2 package files to extras-devel repository..."
		scp ../advanced-systemui_${2}.tar.gz ../advanced-systemui_${2}_armel.changes ../advanced-systemui_${2}.dsc \
			brand@drop.maemo.org:/var/www/extras-devel/incoming-builder/diablo/
	else
		echo "Syntax: $0 release <version>"
	fi
else
	echo "Syntax: $0 <tar/deb/repo/web/n810/icons/themes/release>"
fi
