//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

// milliseconds
#define CPU_UPDATE_PERIOD 2500

#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#ifndef __USE_ISOC99
 #define __USE_ISOC99
#endif
#include <math.h>

#include "main.h"
#include "dbus.h"
#include "cpu.h"

//////////////////////////////////////////////////////////////////////////

static gboolean cpu_update_usage( gpointer data ){
	AsuiBatteryPluginPrivate *p = (AsuiBatteryPluginPrivate *)data;

	if(!p->use_cpu){
		p->cpu_timer = 0;
		return FALSE; // destroy timer
	}

	unsigned usage = 0, total = p->cpu_ticks;
	FILE *in;

	struct timeval tv;
	gettimeofday(&tv, NULL);
	double current_time = (double)tv.tv_sec + (double)tv.tv_usec / 1000000.0;

	if((in = fopen("/proc/stat", "r")) != NULL){
		unsigned user, nice, sys, iowait, irq, softirq;
		float interval = current_time - p->last_cpu_update;

		fscanf(in, "cpu  %u %u %u %*u %u %u %u", &user, &nice, &sys, /* idle, */ &iowait, &irq, &softirq);
		fclose(in);
		total = user + nice + sys + iowait + irq + softirq;
		if(p->cpu_ticks){
			usage = roundf(100.0*(float)(total - p->cpu_ticks) / (float)(p->cpu_ticks_per_second * interval));
			if(usage > 100) usage = 100;
		}

// TODO: this value would need to be divided by the number of cores, if more than one

	}
	p->cpu_ticks = total;
	p->last_cpu_update = current_time;

	     if(usage > 75) p->new_cpu_icon_type = ICON_CPU_100;
	else if(usage > 50) p->new_cpu_icon_type = ICON_CPU_75;
	else if(usage > 25) p->new_cpu_icon_type = ICON_CPU_50;
	else if(usage >  0) p->new_cpu_icon_type = ICON_CPU_25;
	else p->new_cpu_icon_type = ICON_CPU_NONE;
	asui_battery_set_icon(p);

	return TRUE; // repeat timer
}

//////////////////////////////////////////////////////////////////////////

void cpu_init( AsuiBatteryPluginPrivate *p ){
	p->cpu_timer = 0;
	if(p->use_cpu) cpu_enable(p, 1); // hook
}

void cpu_disable( AsuiBatteryPluginPrivate *p, unsigned unhook ){
	if(p->cpu_timer){ g_source_remove(p->cpu_timer); p->cpu_timer = 0; }

	if(unhook) dbus_unhook_display(p);
}

void cpu_enable( AsuiBatteryPluginPrivate *p, unsigned hook ){
	p->cpu_ticks_per_second = sysconf(_SC_CLK_TCK);
	p->cpu_ticks = 0;
	p->last_cpu_update = 0.0;

	cpu_update_usage(p);

	if(p->cpu_timer) g_source_remove(p->cpu_timer);
	p->cpu_timer = (p->display_state ? g_timeout_add(CPU_UPDATE_PERIOD, cpu_update_usage, (void *)p) : 0);

	if(hook) dbus_hook_display(p);
}
