//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "main.h"
#include "dbus.h"
#include "battery.h"

//////////////////////////////////////////////////////////////////////////

static gboolean battery_cycle_charging_icon( gpointer data ){
	AsuiBatteryPluginPrivate *p = (AsuiBatteryPluginPrivate *)data;

	if(p->battery_status == BATTERY_CHARGING){
		switch(p->battery_charging_cycle){
		case 0: p->new_icon_type = ICON_CHARGING_33;  p->battery_charging_cycle = 1; break;
		case 1: p->new_icon_type = ICON_CHARGING_66;  p->battery_charging_cycle = 2; break;
		case 2: p->new_icon_type = ICON_CHARGING_100; p->battery_charging_cycle = 0; break;
		}
		asui_battery_set_icon(p);
		return TRUE; // repeat timer
	}

	p->battery_charging_timer = 0;
	return FALSE; // destroy timer
}

void battery_update_icon( AsuiBatteryPluginPrivate *p ){
	switch(p->battery_status){
	case BATTERY_DRAINING:
		     if(p->battery_capacity > 88) p->new_icon_type = ICON_BATTERY_100;
		else if(p->battery_capacity > 76) p->new_icon_type = ICON_BATTERY_88;
		else if(p->battery_capacity > 64) p->new_icon_type = ICON_BATTERY_76;
		else if(p->battery_capacity > 52) p->new_icon_type = ICON_BATTERY_64;
		else if(p->battery_capacity > 40) p->new_icon_type = ICON_BATTERY_52;
		else if(p->battery_capacity > 28) p->new_icon_type = ICON_BATTERY_40;
		else if(p->battery_capacity > 16) p->new_icon_type = ICON_BATTERY_28;
		else if(p->battery_capacity >  4) p->new_icon_type = ICON_BATTERY_16;
		else p->new_icon_type = ICON_BATTERY_4;
		break;
	case BATTERY_CHARGING:
		p->battery_charging_cycle = 0;
		p->new_icon_type = ICON_CHARGING_100;
		if(!p->battery_charging_timer)
			p->battery_charging_timer = g_timeout_add(1000, battery_cycle_charging_icon, (void *)p);
		break;
	case BATTERY_AC:
		p->new_icon_type = ICON_CHARGED;
		break;
	}
	asui_battery_set_icon(p);
}

//////////////////////////////////////////////////////////////////////////

static gboolean wifi_cycle_state_icon( gpointer data ){
	AsuiBatteryPluginPrivate *p = (AsuiBatteryPluginPrivate *)data;

	if(p->wifi_status == WIFI_CONNECTING || p->wifi_status == WIFI_DISCONNECTING){
		if(p->wifi_state_cycle){
			p->new_wifi_icon_type = ICON_WIFI_CONNECTED;  p->wifi_state_cycle = 0;
		} else {
			p->new_wifi_icon_type = ICON_WIFI_DISCONNECTED;  p->wifi_state_cycle = 1;
		}
		asui_battery_set_icon(p);
		return TRUE; // repeat timer
	}

	p->wifi_state_timer = 0;
	return FALSE; // destroy timer
}

void wifi_update_icon( AsuiBatteryPluginPrivate *p ){
	if(p->use_wifi){
		switch(p->wifi_status){
		case WIFI_FLIGHT_MODE:	p->new_wifi_icon_type = ICON_WIFI_NONE; break;
		case WIFI_DISCONNECTED:	p->new_wifi_icon_type = ICON_WIFI_DISCONNECTED; break;
		case WIFI_CONNECTED:	p->new_wifi_icon_type = ICON_WIFI_CONNECTED; break;
		case WIFI_CONNECTING:
		case WIFI_DISCONNECTING:
			p->wifi_state_cycle = 0;
			p->new_wifi_icon_type = ICON_WIFI_CONNECTED;
			if(!p->wifi_state_timer)
				p->wifi_state_timer = g_timeout_add(500, wifi_cycle_state_icon, (void *)p);
			break;
		}
	} else
		p->new_wifi_icon_type = ICON_WIFI_NONE;
	asui_battery_set_icon(p);
}

//////////////////////////////////////////////////////////////////////////

void bluetooth_update_icon( AsuiBatteryPluginPrivate *p ){
	if(p->use_bluetooth){
		switch(p->bluetooth_status){
		case BLUETOOTH_OFF:					p->new_bluetooth_icon_type = ICON_BLUETOOTH_NONE; break;
		case BLUETOOTH_ON:					p->new_bluetooth_icon_type = ICON_BLUETOOTH_ON; break;
		case BLUETOOTH_CONNECTED:			p->new_bluetooth_icon_type = ICON_BLUETOOTH_CONNECTED; break;
		case BLUETOOTH_ON_VISIBLE:			p->new_bluetooth_icon_type = ICON_BLUETOOTH_ON_VISIBLE; break;
		case BLUETOOTH_CONNECTED_VISIBLE:	p->new_bluetooth_icon_type = ICON_BLUETOOTH_CONNECTED_VISIBLE; break;
		}
	} else
		p->new_bluetooth_icon_type = ICON_BLUETOOTH_NONE;
	asui_battery_set_icon(p);
}

//////////////////////////////////////////////////////////////////////////

static gboolean battery_request_status( gpointer data ){
	AsuiBatteryPluginPrivate *p = (AsuiBatteryPluginPrivate *)data;

	if(p->battery_initializing){
		// send request every 2 seconds until initialized
		dbus_send_system_method(p, "com.qzx.asui", "/com/qzx/asui", "com.qzx.asui", "req_battery_status");
		return TRUE; // repeat timer
	}

	// if charging status is received after capacity signal then icon won't be updated when draining
	// this forces an update to fix the problem
	battery_update_icon(p);
	wifi_update_icon(p);
	bluetooth_update_icon(p);

	p->battery_init_timer = 0;
	return FALSE; // destroy timer
}

//////////////////////////////////////////////////////////////////////////

void battery_init( AsuiBatteryPluginPrivate *p ){
	p->battery_init_timer = 0;
	p->battery_charging_timer = 0;
	if(p->use_battery) battery_enable(p, 1); // hook

	p->wifi_state_timer = 0;
	p->wifi_status = WIFI_FLIGHT_MODE;

	p->bluetooth_status = BLUETOOTH_OFF;
}

void battery_disable( AsuiBatteryPluginPrivate *p, unsigned unhook ){
	if(p->battery_init_timer) g_source_remove(p->battery_init_timer);
	if(p->battery_charging_timer) g_source_remove(p->battery_charging_timer);
	if(p->wifi_state_timer) g_source_remove(p->wifi_state_timer);

	if(unhook)
		dbus_unhook_battery(p);
}

void battery_enable( AsuiBatteryPluginPrivate *p, unsigned hook ){
	p->battery_status = BATTERY_DRAINING;
	p->battery_capacity = 0;
	p->battery_initializing = 1+2+4+8; // status, capacity, wifi, bluetooth

	p->battery_init_timer = g_timeout_add(2000, battery_request_status, (void *)p); // 2 second wait before sending out first request
	p->battery_charging_timer = 0;

	if(hook)
		dbus_hook_battery(p);
}
