//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "main.h"
#include "device_lock.h"

//////////////////////////////////////////////////////////////////////////

// these actions should line up with the power actions in power_button.c
static const char *dl_list4[] = {" ignore ", " LOCK ", " LOCK & BLANK ", " BLANK ", NULL};

//////////////////////////////////////////////////////////////////////////

void device_lock_click_callback( GtkWidget *widget, gpointer data ){
	new_section_vbox("Device Lock"); // add setting widgets to section_content_box

	new_message("Enabling this allows you to manually lock the device with your pin code, make sure you know it!!!");
	new_checkbox(conf_secure_button, "enable secure button", NULL);

	new_selector(conf_secure_action, "action to perform after pressing secure button", dl_list4, NULL);

	new_separator();

	new_selector(conf_secure_power_action_single, "single-tap power button action when device is secured", dl_list4, NULL);
	GtkWidget *pb_double_action = new_selector(conf_secure_power_action_double, "double-tap power button action when device is secured", dl_list4, NULL);
	if(!conf_get_bool(conf_power_enable_double)){
		gtk_widget_set_sensitive(pb_double_action, FALSE); // disable when double-tap support is disabled
		new_message("Double-tap support has been disabled on the power button page");
	}

	new_message("If one of the lock actions isn't assigned to the power button there will be no way to lock the screen while secured (dpad center won't work)");

	new_separator();
}
