//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "main.h"
#include "brightness.h"

//////////////////////////////////////////////////////////////////////////

static GtkWidget *brightness_allow_zero;

static void toggle_checkbox_brightness_enhanced( GtkToggleButton *widget, gpointer data ){
	unsigned state = (gtk_toggle_button_get_active(widget) == TRUE ? 1 : 0);
	conf_set_bool((const char *)data, state);
	if(is_810) gtk_widget_set_sensitive(brightness_allow_zero, (state ? TRUE : FALSE));
}

//////////////////////////////////////////////////////////////////////////

void brightness_click_callback( GtkWidget *widget, gpointer data ){
	new_section_vbox("Brightness"); // add setting widgets to section_content_box

	new_message("Brightness level will NOT be correct after unchecking this setting. You will need to open ASUI and change it.");
	GtkWidget *brightness_enhanced = new_checkbox(conf_brightness_enhanced, "use 127 brightness levels (else 5 levels)", toggle_checkbox_brightness_enhanced);

	new_separator();

	new_message("Enabling this setting allows brightness to be set to zero");
	brightness_allow_zero = new_checkbox(conf_brightness_allow_zero, "allow backlight to be turned off [n810 only]", NULL);
	if(!is_810 || !gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(brightness_enhanced)))
		gtk_widget_set_sensitive(brightness_allow_zero, FALSE); // disable when enhanced brightness is not enabled or device is not an N810

	new_separator();
}
