typedef enum e_service_action { SVC_STOP, SVC_START, SVC_RESTART } e_service_action;

typedef struct s_process {
	char name[80];
	char state;
	unsigned pid;
	unsigned rss;
	unsigned cpu, _ticks;
	unsigned is_service, is_other_service, _alive;
	struct s_process *next;
} s_process;

typedef enum e_ssh_server { SSH_SERVER_OPENSSH, SSH_SERVER_DROPBEAR, SSH_SERVER_NULL } e_ssh_server;

//////////////////////////////////////////////////////////////////////////

#define SVC_BLUETOOTH (1<<0)
#define SVC_GPS (1<<1)
#define SVC_WIFI (1<<2)
#define SVC_AUDIO (1<<3)
#define SVC_DESKTOP (1<<4)
#define SVC_SSH (1<<5)
#define SVC_VPN (1<<6)
#define SVC_SELF (1<<7)
extern unsigned svc_changes;

extern unsigned svc_bluetooth_status, svc_gps_status, svc_wifi_status, svc_audio_status, svc_desktop_status, svc_ssh_status, svc_vpn_status;
extern unsigned svc_bluetooth_size, svc_gps_size, svc_wifi_size, svc_audio_size, svc_desktop_size, svc_ssh_size, svc_vpn_size, svc_self_size;

extern unsigned svc_bluetooth_HCI, svc_bluetooth_BTCOND, svc_bluetooth_OBEX;
extern unsigned svc_gps_DRIVER, svc_gps_SUPL, svc_gps_CLOCKD, svc_gps_GUARD;
extern unsigned svc_wifi_WLANCOND, svc_wifi_DNSMASQ, svc_wifi_CONNDLGS, svc_wifi_ICD, svc_wifi_NTPD;
extern unsigned svc_audio_MULTIMEDIA, svc_audio_DSP, svc_audio_ENGINE, svc_audio_ESD, svc_audio_SERVER;

extern unsigned svc_ssh_installed, svc_ssh_nr_clients;
extern unsigned svc_vpn_installed;

extern unsigned svc_process_viewer, svc_nr_processes;
extern s_process *svc_process_list;

extern double last_svc_refresh;

//////////////////////////////////////////////////////////////////////////

void svc_init( );
void svc_refresh( );

void svc_init_bluetooth( e_service_action action, unsigned with_ticks );
void svc_init_gps( e_service_action action );
void svc_init_wifi( e_service_action action, unsigned with_ticks );
void svc_init_audio( e_service_action action );
void svc_init_desktop( e_service_action action, unsigned with_ticks );
void svc_init_ssh( e_service_action action, unsigned all_servers );
void svc_init_vpn( e_service_action action );
