//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "main.h"
#include "power_button.h"

//////////////////////////////////////////////////////////////////////////

static GtkWidget *pb_double_action;

static void toggle_checkbox_pb_enable_double( GtkToggleButton *widget, gpointer data ){
	unsigned state = (gtk_toggle_button_get_active(widget) == TRUE ? 1 : 0);
	conf_set_bool((const char *)data, state);
	gtk_widget_set_sensitive(pb_double_action, (state ? TRUE : FALSE));
}


// these actions should line up with the secure power actions in device_lock.c
static const char *pb_list_actions[] = {" ignore ", " LOCK ", " LOCK & BLANK ", " BLANK ", " always open ASUI ", " open or close ASUI ", NULL};

static const char *pb_list_puk[] = {" none ", " FULLSCREEN ", " HOME ", " ESCAPE ", " DPAD CENTER ", " MENU ", NULL};

//////////////////////////////////////////////////////////////////////////

void power_button_click_callback( GtkWidget *widget, gpointer data ){
	new_section_vbox("Power Button"); // add setting widgets to section_content_box

	new_message("Double-tap support should be enabled if you have a double-tap action in MCE or if you want to use double-tap actions in ASUI."
				" Disabling support will perform the single-tap action about one second quicker."
				" Changing MCE's double-tap delay can reduce the time to perform single-tap actions.");
	new_checkbox(conf_power_enable_double, "enable power button double-taps", toggle_checkbox_pb_enable_double);
	new_message("ASUI will re-enable this setting if MCE's double-tap action isn't disabled.");

	new_separator();

	new_message("By default the power button will always open ASUI on n800 and open or close it on n810."
				" Always opening ASUI allows the POWER BUTTON + DPAD CENTER combo to always be used to lock the screen."
				" Enabling the first option will always lock&blank the screen and the only way to open ASUI is via the battery applet, ASUI icon or Telescope key combo (see website)."
				" ASUI can always be closed with a swipe from buttons to widgets or the escape key.");
	new_selector(conf_power_action_single, "single-tap power button action when screen is on", pb_list_actions, NULL);
	pb_double_action = new_selector(conf_power_action_double, "double-tap power button action when screen is on", pb_list_actions, NULL);
	if(!conf_get_bool(conf_power_enable_double))
		gtk_widget_set_sensitive(pb_double_action, FALSE); // disable when double-tap support is disabled

	new_separator();

	new_message("MCE will shutdown the device when power button is long pressed, unless the screen is locked."
				" This setting forces ASUI to issue a shutdown command when the power button is long pressed and the screen is locked.");
	new_message("You probably don't want to enable this feature if you use a secondary key to unlock due to accidental power button presses.");
	new_checkbox(conf_power_longpress_shutdown, "enable shutdown when locked", NULL);
	new_message("ASUI will disable this setting if MCE's longpress action isn't set to shutdown.");

	new_separator();

	new_message("The power button can be used to blank the screen when on but locked."
				" When a secondary unlock key is required the power button can be pressed once to turn screen on (but still locked) and a second time to turn it back off."
				" N810 users can use the hardware lock followed by a power button press to lock&blank the screen.");
	new_message("This can lead to unlocking problems on the n800 if the screen won't blank since the secondary key can't be entered.");
	new_checkbox(conf_power_blanks_when_locked, "power button blanks when screen is locked", NULL);

	new_separator();

	new_message("Power button will always turn on the screen and unlock it. This setting will cause it to turn on the screen but keep it locked until a secondary key is pressed.");
	new_selector(conf_power_unlock_key, "secondary key to unlock screen with power button", pb_list_puk, NULL);

	new_separator();
}
