//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "main.h"
#include "mce.h"

//////////////////////////////////////////////////////////////////////////

static const char *mce_actions[] = {" ignore ", " MENU ", " SHUTDOWN ", " SOFT OFF ", NULL};
static const char *mce_real_actions[] = {"disabled", "menu", "poweroff", "softpoweroff"};
typedef struct s_mce_action {
	const char *name;
	enum {PA_NONE, PA_MENU, PA_SHUTDOWN, PA_SOFTOFF} value;
} s_mce_action;
s_mce_action short_action = {"PowerKeyShortAction", PA_NONE}, long_action = {"PowerKeyLongAction", PA_NONE}, double_action = {"PowerKeyDoubleAction", PA_NONE};

typedef struct s_mce_delay {
	const char *name;
	unsigned value;
	unsigned min, max, increment;
	unsigned original_value, original_index;
} s_mce_delay;
s_mce_delay long_delay = {"PowerKeyLongDelay", 1500, 1000, 5000, 500, 0, 0}, double_delay = {"PowerKeyDoubleDelay", 1000, 100, 2000, 100, 0, 0};

//////////////////////////////////////////////////////////////////////////

static void default_mce_delay_selector_callback( GtkComboBox *widget, gpointer data ){
	int index = gtk_combo_box_get_active(widget);
	s_mce_delay *delay = (s_mce_delay *)data;
	if(index > 0 && (unsigned)index == delay->original_index) delay->value = delay->original_value;
	else delay->value = delay->min + delay->increment*(index >= 0 ? index : 0);

	char buffer[200];
	snprintf(buffer, sizeof(buffer), "sed -i \"s:^%s=.*$:%s=%u:\" /etc/mce/mce.ini", delay->name, delay->name, delay->value);
	system(buffer);

	asui_reload_settings();
}
static void new_mce_delay_selector( s_mce_delay *delay, char *name ){
	unsigned value, i, got_current = 0, current = 0;
	char buffer[10];

	// hbox
	GtkWidget *hbox = gtk_hbox_new(FALSE, 10);
	gtk_box_pack_start(GTK_BOX(section_content_box), hbox, FALSE, FALSE, 10);
	gtk_widget_show(hbox);
	// combo box
	GtkWidget *combo_box = gtk_combo_box_new_text();
	for(value = delay->min, i = 0; value <= delay->max; value += delay->increment, i++){
		snprintf(buffer, sizeof(buffer), "%u ms", value);
		gtk_combo_box_append_text(GTK_COMBO_BOX(combo_box), buffer);
		if(delay->value == value){ got_current = 1; current = i; }
	}
	if(!got_current){
		delay->original_value = delay->value;
		delay->original_index = i;
		snprintf(buffer, sizeof(buffer), "%u ms", delay->value);
		gtk_combo_box_append_text(GTK_COMBO_BOX(combo_box), buffer);
		current = i;
	}
	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_box), current);
	gtk_signal_connect(GTK_OBJECT(combo_box), "changed", GTK_SIGNAL_FUNC(default_mce_delay_selector_callback), (void *)delay);
	gtk_box_pack_start(GTK_BOX(hbox), combo_box, FALSE, FALSE, 20);
	gtk_widget_show(combo_box);
	// label
	GtkWidget *label = gtk_label_new(name);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);
}

//////////////////////////////////////////////////////////////////////////

static void default_mce_action_selector_callback( GtkComboBox *widget, gpointer data ){
	int index = gtk_combo_box_get_active(widget);
	s_mce_action *action = (s_mce_action *)data;
	action->value = (index >= 0 ? (unsigned)index : 0);

	char buffer[200];
	snprintf(buffer, sizeof(buffer), "sed -i \"s:^%s=.*$:%s=%s:\" /etc/mce/mce.ini", action->name, action->name, mce_real_actions[action->value]);
	system(buffer);

	asui_reload_settings();
}
static void new_mce_action_selector( s_mce_action *action, char *name ){
	unsigned i, current = 0;

	// hbox
	GtkWidget *hbox = gtk_hbox_new(FALSE, 10);
	gtk_box_pack_start(GTK_BOX(section_content_box), hbox, FALSE, FALSE, 10);
	gtk_widget_show(hbox);
	// combo box
	GtkWidget *combo_box = gtk_combo_box_new_text();
	for(i = 0; mce_actions[i] != NULL; i++){
		gtk_combo_box_append_text(GTK_COMBO_BOX(combo_box), mce_actions[i]);
		if(action->value == i) current = i;
	}
	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_box), current);
	gtk_signal_connect(GTK_OBJECT(combo_box), "changed", GTK_SIGNAL_FUNC(default_mce_action_selector_callback), (void *)action);
	gtk_box_pack_start(GTK_BOX(hbox), combo_box, FALSE, FALSE, 20);
	gtk_widget_show(combo_box);
	// label
	GtkWidget *label = gtk_label_new(name);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);
}

//////////////////////////////////////////////////////////////////////////

static char mce_modules[200];
static void default_mce_als_checkbox_callback( GtkToggleButton *widget, gpointer data ){
	if(gtk_toggle_button_get_active(widget) == TRUE){
		// enable --> Modules=filter-brightness-als;homekey;battery;inactivity;camera;alarm
		system("sed -i \"s:^Modules=:Modules=filter-brightness-als;:\" /etc/mce/mce.ini");
	} else {
		// disable --> Modules=homekey;battery;inactivity;camera;alarm
		char *p, buffer[300];
		if((p = strstr(mce_modules, "filter-brightness-als"))){
			if(mce_modules+strlen(mce_modules) == p+21){
				if(*(p-1) == ';') *(p-1) = '\0'; else *p = '\0'; // bbb;XXX
			} else
				sprintf(p, "%s", p+21+(*(p+21) == ';' ? 1 : 0)); // XXX;aaa and bbb;FOO;aaa
		}
		snprintf(buffer, sizeof(buffer), "sed -i \"s:^Modules=.*$:%s:\" /etc/mce/mce.ini", mce_modules);
		system(buffer);
	}
}
static void new_mce_als_checkbox( unsigned state, char *label ){
	GtkWidget *checkbox = gtk_check_button_new_with_label(label);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbox), state);
	gtk_signal_connect(GTK_OBJECT(checkbox), "toggled", GTK_SIGNAL_FUNC(default_mce_als_checkbox_callback), NULL);
	gtk_box_pack_start(GTK_BOX(section_content_box), checkbox, FALSE, FALSE, 10);
	gtk_widget_show(checkbox);
}

//////////////////////////////////////////////////////////////////////////

static void get_action( s_mce_action *action, char *value ){
	value[strlen(value)-1] = '\0';
	if(!strcmp(value, "menu")) action->value = PA_MENU;
	else if(!strcmp(value, "poweroff")) action->value = PA_SHUTDOWN;
	else if(!strcmp(value, "softpoweroff")) action->value = PA_SOFTOFF;
	else action->value = PA_NONE;
}

static void click_restart_mce_callback(GtkWidget *widget, gpointer data){
	system("/etc/init.d/mce restart");
}

//////////////////////////////////////////////////////////////////////////

void mce_click_callback( GtkWidget *widget, gpointer data ){
	new_section_vbox("MCE"); // add setting widgets to section_content_box

	// read mce.ini
	unsigned filter_brightness_als = 0;
	{
		FILE *in;
		if((in = fopen("/etc/mce/mce.ini", "r")) != NULL){
			while(!feof(in)){
				char line[400];
				fgets(line, 400, in);
				if(feof(in)) break;

				if(!strncmp(line, "Modules=", 8)){
					// get filter-brightness-als setting
					if(strstr(line, "filter-brightness-als") != NULL) filter_brightness_als = 1;
					strncpy(mce_modules, line, sizeof(mce_modules));
					mce_modules[strlen(mce_modules)-1] = '\0';
				} else if(!strncmp(line, "PowerKeyLongDelay=", 18)){
					// get long delay, unless commented out
					sscanf(&line[18], "%u", &long_delay.value);
				} else if(!strncmp(line, "PowerKeyDoubleDelay=", 20)){
					// get double delay, unless commented out
					sscanf(&line[20], "%u", &double_delay.value);
				} else if(!strncmp(line, "PowerKeyShortAction=", 20)){
					// get short action, assume 'disabled' if commented out
					get_action(&short_action, &line[20]);
				} else if(!strncmp(line, "PowerKeyLongAction=", 19)){
					// get long action, assume 'disabled' if commented out
					get_action(&long_action, &line[19]);
				} else if(!strncmp(line, "PowerKeyDoubleAction=", 21)){
					// get double action, assume 'disabled' if commented out
					get_action(&double_action, &line[21]);
				}
			}
			fclose(in);
		}
	}

	new_mce_delay_selector(&long_delay, "long-press power button delay (default: 1500)");
	new_mce_delay_selector(&double_delay, "double-tap power button delay (default: 1000)");

	new_message("ASUI's single-tap actions should be set to 'ignore' if MCE's single-tap action is set to shutdown or soft off.");
	new_mce_action_selector(&short_action, "single-tap power button action (default: menu)");
	new_mce_action_selector(&long_action, "long-press power button action (default: shutdown)");
	new_mce_action_selector(&double_action, "double-tap power button action (default: disabled)");
	new_message("ASUI's double-tap actions should be set to 'ignore' if MCE's double-tap action is set to shutdown or soft off.");
	new_message("ASUI will always enable double-tap support if MCE's double-tap action is not ignored.");

	new_separator();

	new_mce_als_checkbox(filter_brightness_als, "auto-adjust brightness with ambient light sensor");

	new_separator();

	new_button(section_content_box, "Restart MCE", click_restart_mce_callback, NULL);

	new_separator();
}
