//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "main.h"
#include "button_modes.h"

//////////////////////////////////////////////////////////////////////////

static const char *bm_list5[] = {" not bound ", " LOCK ", " LOCK & BLANK ", " BLANK ", " SECURE ", NULL};

//////////////////////////////////////////////////////////////////////////

void button_modes_click_callback( GtkWidget *widget, gpointer data ){
	new_section_vbox("Button Modes"); // add setting widgets to section_content_box

	new_checkbox(conf_double_tap, "require double taps to start and stop services", NULL);

	new_separator();

	new_message("This works with the lock button (short and long), the secure button and the dpad center button");
	new_checkbox(conf_lock_and_close, "close ASUI after locking touchscreen", NULL);

	new_separator();

	new_message("This does not effect rotating with hardware keys (BRV keys)");
	new_checkbox(conf_rotate_and_close, "close ASUI after rotating with on-screen buttons", NULL);

	new_separator();

	new_message("Both lock buttons can be split in two halves so short tapping the bottom half triggers the short press action and short tapping the top half triggers the long press action."
				" Long pressing is disabled when the buttons are split.");
	new_checkbox(conf_split_lock_buttons, "split lock buttons to avoid long presses", NULL);

	new_selector(conf_buttons_dpad_short, "DPAD CENTER short press", bm_list5, NULL);
	new_selector(conf_buttons_dpad_long, "DPAD CENTER long press", bm_list5, NULL);
	new_selector(conf_buttons_lock1_short, "lock button #1 short press", bm_list5, NULL);
	new_selector(conf_buttons_lock1_long, "lock button #1 long press", bm_list5, NULL);
	new_selector(conf_buttons_lock2_short, "lock button #2 short press", bm_list5, NULL);
	new_selector(conf_buttons_lock2_long, "lock button #2 long press", bm_list5, NULL);

	new_separator();
}
