//	Advanced System UI
//	Copyright (c) 2010-2011 Brand Huntsman <brand.huntsman@gmail.com>

// seconds (double)
#define REFRESH_PERIOD 60.0

#include <stdio.h>
#ifndef __USE_ISOC99
 #define __USE_ISOC99
#endif
#include <math.h>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "hardware.h"
#include "dialog.h"
 #include "governor_dsp.h"

////////////////////////////////////////////////////////////////////////// LOCALS

static unsigned waiting_on_governors;

//////////////////////////////////////////////////////////////////////////

static void draw_governor_dsp( unsigned force ){
	// force is not needed

	// dialog background
	x_set_color(bg_color);
	x_fill_rectangle(0, 0, window.width, window.height);

	int y, cpu_x, dsp_x, dsp_y;
	if(window.width > window.height){
		// landscape
		cpu_x = 50+150;
		dsp_x = 450+150;
		dsp_y = 0;
	} else {
		// portrait
		cpu_x = dsp_x = window.width>>1;
		dsp_y = 400;
	}

	// governors
	s_hw_governor *g;
	draw_text("CPU Policy", 24, fg1_color, cpu_x, 20, ALIGN_CENTER, ALIGN_TOP, 0);
	if(hw_cpu.governor_list){
		for(g = hw_cpu.governor_list, y = 50; g != NULL; g = g->next, y += 70){
			x_set_color((g == hw_cpu.current_governor ? green_status_color : fg2_color));
			x_draw_rectangle(cpu_x-150, y, 300,60);
			draw_text(g->name, 18, (g == hw_cpu.current_governor ? green_status_color : fg2_color), cpu_x, y+30, ALIGN_CENTER, ALIGN_MIDDLE, 0);
		}
		waiting_on_governors = 0;
	} else {
		draw_text("...governor list hasn't loaded yet...", 18, red_status_color, cpu_x, 240, ALIGN_CENTER, ALIGN_MIDDLE, 0);
		waiting_on_governors = 1;
	}

	// clock stats
	FILE *in;
	float tis_400 = 0, tis_330 = 0, tis_266 = 0, tis_165 = 0;
	if((in = fopen("/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state", "r")) != NULL){
		while(!feof(in)){
			char line[100];
			unsigned clock, tis;
			fgets(line, sizeof(line), in);
			if(feof(in)) break;
			sscanf(line, "%u %u\n", &clock, &tis);
			switch(clock){
			case 400000: tis_400 = tis; break;
			case 330000: tis_330 = tis; break;
			case 266000: tis_266 = tis; break;
			case 165000: tis_165 = tis; break;
			}
		}
		fclose(in);
	}
	float tis_total = tis_400 + tis_330 + tis_266 + tis_165;
	tis_400 = roundf(10000.0 * tis_400 / tis_total) / 100.0;
	tis_330 = roundf(10000.0 * tis_330 / tis_total) / 100.0;
	tis_266 = roundf(10000.0 * tis_266 / tis_total) / 100.0;
	tis_165 = roundf(10000.0 * tis_165 / tis_total) / 100.0;

	// DSP clock ratios
	s_hw_dsp_clock *clock;
	draw_text("CPU / DSP MHz", 24, fg1_color, dsp_x, dsp_y+20, ALIGN_CENTER, ALIGN_TOP, 0);
	if(hw_cpu.dsp_clocks){
		unsigned op_locked = get_file_value("/sys/power/op_locked");
		unsigned ratio = 0, current_ratio = get_file_value("/sys/power/op_dsp");
		for(clock = hw_cpu.dsp_clocks, y = dsp_y+50; clock != NULL; clock = clock->next, y += 70, ratio++){
			char buffer[30];
			snprintf(buffer, sizeof(buffer), "%u / %u", clock->cpu, clock->dsp);
			x_set_color((ratio == current_ratio ? (op_locked ? red_status_color : green_status_color) : fg2_color));
			x_draw_rectangle(dsp_x-150, y, 300,60);
			draw_text(buffer, 18, (ratio == current_ratio ? (op_locked ? red_status_color : green_status_color) : fg2_color),
						dsp_x, y+30, ALIGN_CENTER, ALIGN_MIDDLE, 0);

			// time in state
			float tis = -1.0;
			switch(clock->cpu){
			case 400: tis = tis_400; break;
			case 330: tis = tis_330; break;
			case 266: tis = tis_266; break;
			case 165: tis = tis_165; break;
			}
			snprintf(buffer, sizeof(buffer), "%.2f%%", tis);
			draw_text(buffer, 16, fg2_color, dsp_x-158, y+30, ALIGN_RIGHT, ALIGN_MIDDLE, 0);
		}
	} else {
		draw_text("...install Diablo-Turbo...", 18, red_status_color, dsp_x, dsp_y+220, ALIGN_CENTER, ALIGN_MIDDLE, 0);
		draw_text("330 / 220", 18, green_status_color, dsp_x, dsp_y+260, ALIGN_CENTER, ALIGN_MIDDLE, 0);
	}

	// close button
	x_set_color(line_color);
	int x = window.width-240; y = window.height-60;
	x_draw_line(x, y, window.width, y);
	x_draw_line(x, y, x, window.height);
	draw_text("Close", 24, fg2_color, window.width-120, window.height-20, ALIGN_CENTER, ALIGN_BASELINE, 0);

	hw_changes = 0;
	reset_timer(&dialog_refresh_timer);
}

static void click_governor_dsp( ){
	if(click.type != CLICK_SHORT) return; // no long press or drag support

	int y, cpu_x, dsp_x, dsp_y;
	if(window.width > window.height){
		// landscape
		cpu_x = 50+150;
		dsp_x = 450+150;
		dsp_y = 0;
	} else {
		// portrait
		cpu_x = dsp_x = window.width>>1;
		dsp_y = 400;
	}

	// governors
	if(!waiting_on_governors){
		s_hw_governor *g;
		for(g = hw_cpu.governor_list, y = 50; g != NULL; g = g->next, y += 70){
			if(click.y >= y && click.y <= y+60 && click.x >= cpu_x-150 && click.x <= cpu_x+150){
				if(g != hw_cpu.current_governor){
					highlight_selected_area(cpu_x-150, y, 301,61);
					hw_set_governor(g);
					draw_governor_dsp(1);
				}
				return;
			}
		}
	}

	// DSP clock ratios
	if(!get_file_value("/sys/power/op_locked")){
		unsigned ratio = 0, current_ratio = get_file_value("/sys/power/op_dsp");
		s_hw_dsp_clock *clock;
		for(clock = hw_cpu.dsp_clocks, y = dsp_y+50; clock != NULL; clock = clock->next, y += 70, ratio++){
			if(click.y >= y && click.y <= y+60 && click.x >= dsp_x-150 && click.x <= dsp_x+150){
				if(ratio != current_ratio){
					highlight_selected_area(dsp_x-150, y, 301,61);
					hw_set_dsp_ratio(ratio);
					draw_governor_dsp(1);
				}
				return;
			}
		}
	}

	// close button
	if(click.y > (int)window.height-60 && click.x > (int)window.width-240){
		highlight_selected_area(window.width-240, window.height-60, 240,60);
		dialog_close();
	}
}

static void keypress_governor_dsp( ){
	switch(keypress.keycode){
	case KEYCODE_ESCAPE:
		// close dialog
		if(keypress.type == KEY_SHORT){
			highlight_selected_area(window.width-240, window.height-60, 240,60);
			dialog_close();
		}
		break;
	default:
		if(!dpadlock_keypress_handler())
			brv_keypress_handler();
				// ignore all other keys
		break;
	}
}

//////////////////////////////////////////////////////////////////////////

void governor_dsp_open_dialog( ){
	dialog_open(draw_governor_dsp, click_governor_dsp, keypress_governor_dsp, NULL, DLG_REDRAW_ON);
	set_timer(&dialog_refresh_timer, REFRESH_PERIOD);
}
