//	Advanced System UI
//	Copyright (c) 2010-2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "config.h"
#include "hardware.h"

#include "button_rotate.h"

//////////////////////////////////////////////////////////////////////////

#ifdef ARCH_armel
 #define X_OFFSET 2
 #define Y_OFFSET 3
 #define P_SHIFT -1
 #define PI_SHIFT +1
#else
 #define X_OFFSET 0
 #define Y_OFFSET 0
 #define P_SHIFT +1
 #define PI_SHIFT +0
#endif

void draw_long_tap_marker( int x, int y, e_orientation orientation, int x_shift ){
	x_set_color(secondary_selection_color);
	switch(orientation){
	case O_PORTRAIT:		x_draw_line(x+43-Y_OFFSET+x_shift,y+37+X_OFFSET P_SHIFT,  x+43-Y_OFFSET+x_shift,y+42+X_OFFSET P_SHIFT);
							x_draw_line(x+44-Y_OFFSET+x_shift,y+35+X_OFFSET P_SHIFT,  x+44-Y_OFFSET+x_shift,y+44+X_OFFSET P_SHIFT); break; // left vertical line

	case O_PORTRAIT_INV:	x_draw_line(x+36+Y_OFFSET        ,y+38-X_OFFSET PI_SHIFT, x+36+Y_OFFSET        ,y+43-X_OFFSET PI_SHIFT);
							x_draw_line(x+35+Y_OFFSET        ,y+36-X_OFFSET PI_SHIFT, x+35+Y_OFFSET        ,y+45-X_OFFSET PI_SHIFT); break; // right vertical line

	case O_LANDSCAPE:		break;

	case O_LANDSCAPE_INV:	x_draw_line(x+37+X_OFFSET,y+36+Y_OFFSET, x+42+X_OFFSET,y+36+Y_OFFSET);
							x_draw_line(x+35+X_OFFSET,y+35+Y_OFFSET, x+44+X_OFFSET,y+35+Y_OFFSET); break; // bottom horizontal line
	}
}

void draw_rotate1_button( unsigned force, int x, int y ){
	if(!window.supports_rotation) return;

	if(force){
		// background for all buttons is cleared by draw_window()
	} else if(hw_changes & HW_ROTATION){
		// button background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 80, 80);
	} else return;

	if(window.width > window.height){
		if(window.orientation == O_LANDSCAPE){
			draw_image(&im_portrait, x+8, y+8 P_SHIFT);
			draw_long_tap_marker(x,y, O_PORTRAIT, 0);
		} else {
			draw_image(&im_landscape_inv, x+8, y+8);
			draw_long_tap_marker(x,y, O_LANDSCAPE_INV, 0);
		}
	} else {
		if(window.orientation == O_PORTRAIT){
			draw_image(&im_portrait_inv, x+8, y+8 PI_SHIFT);
			draw_long_tap_marker(x,y, O_PORTRAIT_INV, 0);
		} else {
			draw_image(&im_portrait, x+8 +1, y+8 P_SHIFT); // x_shift
			draw_long_tap_marker(x,y, O_PORTRAIT, +1);
		}
	}

	draw_tap_markers(x, y, 80, 1, 0); // short tap only
}

void draw_rotate2_button( unsigned force, int x, int y ){
	if(!window.supports_rotation) return;

	if(force){
	// background for all buttons is cleared by draw_window()
	} else if(hw_changes & HW_ROTATION){
		// button background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 80, 80);
	} else return;

	if(window.width > window.height){
		if(window.orientation == O_LANDSCAPE){
			draw_image(&im_landscape_inv, x+8, y+8);
			draw_long_tap_marker(x,y, O_LANDSCAPE_INV, 0);
		} else {
			draw_image(&im_portrait_inv, x+8, y+8 PI_SHIFT);
			draw_long_tap_marker(x,y, O_PORTRAIT_INV, 0);
		}
	} else {
		if(window.orientation == O_PORTRAIT){
			draw_image(&im_portrait, x+8 +1, y+8 P_SHIFT); // x_shift
			draw_long_tap_marker(x,y, O_PORTRAIT, +1);
		} else {
			draw_image(&im_landscape_inv, x+8, y+8);
			draw_long_tap_marker(x,y, O_LANDSCAPE_INV, 0);
		}
	}

	draw_tap_markers(x, y, 80, 1, 0); // short tap only
}

void draw_rotate3_button( unsigned force, int x, int y ){
	if(!window.supports_rotation) return;

	if(force){
		// background for all buttons is cleared by draw_window()
	} else if(hw_changes & HW_ROTATION){
		// button background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 80, 80);
	} else return;

	if(window.width > window.height){
		if(window.orientation == O_LANDSCAPE){
			draw_image(&im_portrait_inv, x+8, y+8 PI_SHIFT);
			draw_long_tap_marker(x,y, O_PORTRAIT_INV, 0);
		} else {
			draw_image(&im_portrait, x+8, y+8 P_SHIFT);
			draw_long_tap_marker(x,y, O_PORTRAIT, 0);
		}
	} else {
		if(window.orientation == O_PORTRAIT){
			draw_image(&im_landscape_inv, x+8, y+8);
			draw_long_tap_marker(x,y, O_LANDSCAPE_INV, 0);
		} else {
			draw_image(&im_portrait_inv, x+8, y+8 PI_SHIFT);
			draw_long_tap_marker(x,y, O_PORTRAIT_INV, 0);
		}
	}

	draw_tap_markers(x, y, 80, 1, 0); // short tap only
}

//////////////////////////////////////////////////////////////////////////

void click_rotate1_button( ){
	if(!window.supports_rotation) return;

	if(click.type == CLICK_HOLD){

		// highlight to indicate long press
		highlight_long_press(widget_x, widget_y, 80,80);

	} else if(click.type == CLICK_SHORT || click.type == CLICK_LONG){

		if(throttle_taps(&ui_throttle)) return;

		highlight_selected_area(widget_x, widget_y, 80,80);
		unsigned keep_mapped = (click.type == CLICK_SHORT ? !cfg_rotate_and_close : cfg_rotate_and_close);
		if(window.orientation != O_LANDSCAPE)
			rotate_screen(O_LANDSCAPE, keep_mapped);
		else
			rotate_screen(O_PORTRAIT, keep_mapped);

		finalize_tap(ui_throttle);

	}
}

void click_rotate2_button( ){
	if(!window.supports_rotation) return;

	if(click.type == CLICK_HOLD){

		// highlight to indicate long press
		highlight_long_press(widget_x, widget_y, 80,80);

	} else if(click.type == CLICK_SHORT || click.type == CLICK_LONG){

		if(throttle_taps(&ui_throttle)) return;

		highlight_selected_area(widget_x, widget_y, 80,80);
		unsigned keep_mapped = (click.type == CLICK_SHORT ? !cfg_rotate_and_close : cfg_rotate_and_close);
		if(window.orientation != O_LANDSCAPE && window.orientation != O_PORTRAIT)
			rotate_screen(O_PORTRAIT, keep_mapped);
		else
			rotate_screen(O_LANDSCAPE_INV, keep_mapped);
		//  l   pLP
		//  p   lLP
		//  L   lpP
		//  P   lpL

		finalize_tap(ui_throttle);

	}
}

void click_rotate3_button( ){
	if(!window.supports_rotation) return;

	if(click.type == CLICK_HOLD){

		// highlight to indicate long press
		highlight_long_press(widget_x, widget_y, 80,80);

	} else if(click.type == CLICK_SHORT || click.type == CLICK_LONG){

		if(throttle_taps(&ui_throttle)) return;

		highlight_selected_area(widget_x, widget_y, 80,80);
		unsigned keep_mapped = (click.type == CLICK_SHORT ? !cfg_rotate_and_close : cfg_rotate_and_close);
		if(window.orientation != O_PORTRAIT_INV)
			rotate_screen(O_PORTRAIT_INV, keep_mapped);
		else
			rotate_screen(O_LANDSCAPE_INV, keep_mapped);

		finalize_tap(ui_throttle);

	}
}

////////////////////////////////////////////////////////////////////////// BUTTON

s_button button_rotate1 = {"rotate1", "/apps/asui_state/bcell_rotate1", draw_rotate1_button, click_rotate1_button, 0};
s_button button_rotate2 = {"rotate2", "/apps/asui_state/bcell_rotate2", draw_rotate2_button, click_rotate2_button, 0};
s_button button_rotate3 = {"rotate3", "/apps/asui_state/bcell_rotate3", draw_rotate3_button, click_rotate3_button, 0};
