//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"
#include "hardware.h"
#include "dbus.h"

//////////////////////////////////////////////////////////////////////////

static void draw_lock_action( int x, int y, unsigned action, unsigned long_press ){
	int w = 0, disabled = 0;

	switch(action){
	case 0: // not bound
		break;
	case 1: // lock
		w = draw_text("LOCK", 12, fg1_color, x, y, ALIGN_CENTER, ALIGN_BASELINE, 0);
		break;
	case 2: // lock&blank
		w = draw_text("LK-BLANK", 12, (disabled ? line_color : fg1_color), x, y, ALIGN_CENTER, ALIGN_BASELINE, 0);
		break;
	case 3: // blank
		w = draw_text("BLANK", 12, (disabled ? line_color : fg1_color), x, y, ALIGN_CENTER, ALIGN_BASELINE, 0);
		break;
	case 4: // secure
		if(!cfg_secure_button) disabled = 1;
		w = draw_text("SECURE", 12, (disabled ? line_color : fg1_color), x, y, ALIGN_CENTER, ALIGN_BASELINE, 0);
		break;
	}
	// draw border
	if(w){
		if(long_press && !cfg_split_lock_buttons) x_set_style(1, LineOnOffDash);
		x_set_color(line_color);
		x_draw_rectangle(x-32, y-15, 64,20);
		if(long_press && !cfg_split_lock_buttons) x_reset_style();
		if(!disabled){
			if(long_press && !cfg_split_lock_buttons)
				draw_tap_markers(x-32, y-15, 21, 0, 1); // long tap marker
			else
				draw_tap_markers(x-32, y-15, 21, 1, 0); // short tap marker
		}
	}
}

void draw_lock1_button( unsigned force, int x, int y ){
	if(force){
		// background for all buttons is cleared by draw_window()
	} else if(hw_changes & HW_BATTERY){
		// button background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 80, 80);
	} else return;

	unsigned cx = x+40, cy = y+40;

	if(cfg_buttons_lock1_short == cfg_buttons_lock1_long || cfg_buttons_lock1_long == 0){
		draw_lock_action(cx, cy+5, cfg_buttons_lock1_short, 0);
	} else if(cfg_buttons_lock1_short == 0){
		draw_lock_action(cx, cy+5, cfg_buttons_lock1_long, 1);
	} else {
		draw_lock_action(cx, cy-9, cfg_buttons_lock1_long, 1);
		draw_lock_action(cx, cy+18, cfg_buttons_lock1_short, 0);
	}
}

void draw_lock2_button( unsigned force, int x, int y ){
	if(force){
		// background for all buttons is cleared by draw_window()
	} else if(hw_changes & HW_BATTERY){
		// button background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 80, 80);
	} else return;

	unsigned cx = x+40, cy = y+40;

	if(cfg_buttons_lock2_short == cfg_buttons_lock2_long || cfg_buttons_lock2_long == 0){
		draw_lock_action(cx, cy+5, cfg_buttons_lock2_short, 0);
	} else if(cfg_buttons_lock2_short == 0){
		draw_lock_action(cx, cy+5, cfg_buttons_lock2_long, 1);
	} else {
		draw_lock_action(cx, cy-9, cfg_buttons_lock2_long, 1);
		draw_lock_action(cx, cy+18, cfg_buttons_lock2_short, 0);
	}
}

//////////////////////////////////////////////////////////////////////////

static void click_lock_button( unsigned cfg, unsigned top, unsigned bottom ){
	unsigned y_offset = (top ? 0 : 40), height = (top && bottom ? 80 : 40);

	// no tap throttling
	highlight_selected_area(widget_x, widget_y+y_offset, 80,height);
	press_lock_button(cfg);
	unhighlight_selected_area(widget_x, widget_y+y_offset, 80,height);
}

void click_lock1_button( ){
	if(click.type == CLICK_HOLD && cfg_buttons_lock1_long && !cfg_split_lock_buttons){

		// highlight to indicate long press
		highlight_long_press(widget_x, widget_y, 80,80);

	} else if(click.type == CLICK_SHORT){

		if(cfg_split_lock_buttons){
			if(click.y >= 40){
				if(cfg_buttons_lock1_short) click_lock_button(cfg_buttons_lock1_short, 0,1);
			} else {
				if(cfg_buttons_lock1_long) click_lock_button(cfg_buttons_lock1_long, 1,0);
			}
		} else if(cfg_buttons_lock1_short)
			click_lock_button(cfg_buttons_lock1_short, 1,1);

	} else if(click.type == CLICK_LONG && cfg_buttons_lock1_long && !cfg_split_lock_buttons){

		click_lock_button(cfg_buttons_lock1_long, 1,1);

	}
}

void click_lock2_button( ){
	if(click.type == CLICK_HOLD && cfg_buttons_lock2_long && !cfg_split_lock_buttons){

		// highlight to indicate long press
		highlight_long_press(widget_x, widget_y, 80,80);

	} else if(click.type == CLICK_SHORT){

		if(cfg_split_lock_buttons){
			if(click.y >= 40){
				if(cfg_buttons_lock2_short) click_lock_button(cfg_buttons_lock2_short, 0,1);
			} else {
				if(cfg_buttons_lock2_long) click_lock_button(cfg_buttons_lock2_long, 1,0);
			}
		} else if(cfg_buttons_lock2_short)
			click_lock_button(cfg_buttons_lock2_short, 1,1);

	} else if(click.type == CLICK_LONG && cfg_buttons_lock2_long && !cfg_split_lock_buttons){

		click_lock_button(cfg_buttons_lock2_long, 1,1);

	}
}

////////////////////////////////////////////////////////////////////////// BUTTON

s_button button_lock1 = {"lock1", "/apps/asui_state/bcell_lock1", draw_lock1_button, click_lock1_button, 0};
s_button button_lock2 = {"lock2", "/apps/asui_state/bcell_lock2", draw_lock2_button, click_lock2_button, 0};
