//	Advanced System UI
//	Copyright (c) 2010-2011 Brand Huntsman <brand.huntsman@gmail.com>

#include <unistd.h>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"
#include "services.h"
#include "hardware.h"

//////////////////////////////////////////////////////////////////////////

static unsigned ticks_visible;

void draw_wifi_widget( unsigned force, int x, int y ){
	if(force){
		// background for all widgets is cleared by draw_window()
		wifi_widget_page = primary_widgets;
	} else if(hw_changes & HW_WIFI || svc_changes & SVC_WIFI){
		// widget background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 399, 99);
	} else return;

	draw_text("WiFi", 32, fg1_color, x+20, y+50, ALIGN_LEFT, ALIGN_MIDDLE, 0);
	draw_hardware_indicator(hw_wifi.enabled, x, y);
	draw_services_indicator(svc_wifi_status, x+299, y+50, 60);
	draw_rss(svc_wifi_size, x+390, y+90);

	draw_tap_markers(x, y, 99, 1, !hw_wifi.enabled); // short & long taps (autoconnect & selection dialog)
	draw_tap_markers(x+200, y, 99, 1, 0); // short tap only (services)

	// connection name and state
	if(hw_wifi.state == WIFI_CONNECTED){
		if(hw_wifi.name)
			draw_text(hw_wifi.name, 16, fg1_color, x+20, y+15, ALIGN_LEFT, ALIGN_TOP, 170);

		draw_text("Connected", 16, red_status_color, x+60, y+70, ALIGN_LEFT, ALIGN_TOP, 0);

		if(hw_wifi.address)
			draw_text(hw_wifi.address, 13, fg1_color, x+210, y+90, ALIGN_LEFT, ALIGN_BOTTOM, 0);
	} else if(hw_wifi.state == WIFI_CONNECTING)
		draw_text("C o n n e c t i n g ...", 16, red_status_color, x+60, y+70, ALIGN_LEFT, ALIGN_TOP, 0);
	else if(hw_wifi.state == WIFI_DISCONNECTING)
		draw_text("Disconnecting ...", 16, yellow_status_color, x+60, y+70, ALIGN_LEFT, ALIGN_TOP, 0);

	ticks_visible = 0;
}

//////////////////////////////////////////////////////////////////////////

static s_tap_throttler wifi_throttle;

void click_wifi_widget( ){
	if(click.type == CLICK_DOWN || click.type == CLICK_MOTION || click.type == CLICK_DRAG) return; // no drag support

	if(click.x >= 200){

		if(click.type != CLICK_SHORT) return; // no long press support

		// require double tap if enabled and service is fully started or stopped
		// partial state always uses a single tap
		if(svc_wifi_status != 1)
			if(!get_double_tap(Z_MAIN_SVC_WIFI)) return;

		if(throttle_taps(&wifi_throttle)) return;

		{
			if(svc_wifi_status == 1 && click.x >= 300){
				highlight_selected_area(widget_x+300, widget_y, 99, 99);
				svc_wifi_status = 0; // attempt to start services
			} else
				highlight_selected_area(widget_x+200, widget_y, (svc_wifi_status == 1 ? 99 : 199), 99);

			if(svc_wifi_status)
				svc_init_wifi(SVC_STOP, 0);
			else {
				init_ticks(widget_x+266, widget_y+20, gray_status_color);
				svc_init_wifi(SVC_START, 1); // display ticks

				// give services 8 seconds to start
				unsigned i; for(i = 0; i < 8; i++){ draw_tick(); sleep(1); }
			}

			svc_changes |= SVC_WIFI;
			draw_wifi_widget(0, widget_x, widget_y); // update service dot
		}

		finalize_tap(wifi_throttle);

	} else if(hw_wifi.enabled){

		if(click.type != CLICK_SHORT) return; // no long press support

		if(throttle_taps(&wifi_throttle)) return;

		// turn off hardware (disconnect)
		highlight_selected_area(widget_x, widget_y, 198, 99);
		hw_wifi_disconnect();
		// highlight will be cleared when client receives disconnect signal

		finalize_tap(wifi_throttle);

	} else if(click.type == CLICK_HOLD){

		// highlight to indicate long press
		highlight_long_press(widget_x, widget_y, 198, 99);

	} else {

		if(throttle_taps(&wifi_throttle)) return;

		{
			unsigned i;

			if(ticks_visible){
				hw_changes |= HW_WIFI;
				draw_wifi_widget(0, widget_x, widget_y); // ticks are still visible from a failed connection attempt, clear them
			}

			highlight_selected_area(widget_x, widget_y, 198, 99);

			// enable normal mode
			if(hw_flight_mode){
				mce_normal_mode();
				draw_window(0); // update flight mode icon

				// restore highlight (just in case)
				highlight_selected_area(widget_x, widget_y, 198, 99);
			}

			if(svc_wifi_status != 2){
				// starting services takes a bit, display ticks
				init_ticks(widget_x+266, widget_y+20, red_status_color);

				// start services before enabling hardware
				svc_init_wifi(SVC_START, 1); // display ticks
				if(svc_wifi_status != 2){
					// failed to start services
					hw_changes |= HW_WIFI;
					svc_changes |= SVC_WIFI;
					draw_wifi_widget(0, widget_x, widget_y);
					finalize_tap(wifi_throttle);
					return;
				}

				// give services 8 seconds to start
				for(i = 0; i < 8; i++){
					draw_tick();
					sleep(1);
				}

				svc_changes |= SVC_WIFI;
				draw_wifi_widget(0, widget_x, widget_y); // update service dot

				// restore highlight
				highlight_selected_area(widget_x, widget_y, 198, 99);
			}

			// connect
			if(click.type == CLICK_SHORT)
				hw_wifi_auto_connect(); // auto connect on SHORT press
			else
				hw_wifi_open_selector(); // open wifi selector dialog on LONG press

			// display a couple ticks
			init_ticks(widget_x+60, widget_y+71, red_status_color);
			for(i = 0; i < 3; i++){
				draw_tick();
				sleep(1);
			}
			ticks_visible = 1;

			// ticks will clear and hardware mark will light up when client receives connect signal
			unhighlight_selected_area(widget_x, widget_y, 198, 99);
		}

		finalize_tap(wifi_throttle);

	}
}

////////////////////////////////////////////////////////////////////////// WIDGET

s_widget widget_wifi = {"WiFi", "/apps/asui_state/cell_wifi", FULL_WIDGET, draw_wifi_widget, click_wifi_widget, 0};
