//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "main.h"
#include "button_modes.h"

//////////////////////////////////////////////////////////////////////////

static const char *bm_list5[] = {" not bound ", " LOCK ", " LOCK & BLANK ", " BLANK ", " SECURE ", NULL};
static const char *bm_list4[] = {" nothing ",   " LOCK ", " LOCK & BLANK ", " BLANK ",             NULL};
static const char *bm_list3[] = {               " LOCK ", " LOCK & BLANK ", " BLANK ",             NULL};

static const char *bm_list_pa[] = {" LOCK & BLANK ", " always open ASUI ", " open or close ASUI ", NULL};
static const char *bm_list_puk[] = {" none ", " FULLSCREEN ", " HOME ", " ESCAPE ", " DPAD CENTER ", " MENU ", NULL};

//////////////////////////////////////////////////////////////////////////

void button_modes_click_callback( GtkWidget *widget, gpointer data ){
	new_section_vbox("Button Modes"); // add setting widgets to section_content_box

	new_checkbox(conf_double_tap, "require double taps to start and stop services", NULL);

	new_separator();

	new_message("This works with the lock button (short and long), the secure button and the dpad center button");
	new_checkbox(conf_lock_and_close, "close ASUI after locking touchscreen", NULL);

	new_separator();

	new_message("This does not effect rotating with hardware keys (BRV keys)");
	new_checkbox(conf_rotate_and_close, "close ASUI after rotating with on-screen buttons", NULL);

	new_separator();

	new_message("Enabling this allows you to manually lock the device with your pin code, make sure you know it!!!");
	new_checkbox(conf_secure_button, "enable secure button", NULL);
	new_message("None of the secure options below will work unless this is enabled");

	new_selector(conf_buttons_dpad_short, "DPAD CENTER short press", bm_list5, NULL);
	new_selector(conf_buttons_dpad_long, "DPAD CENTER long press", bm_list5, NULL);
	new_selector(conf_buttons_lock1_short, "lock button #1 short press", bm_list5, NULL);
	new_selector(conf_buttons_lock1_long, "lock button #1 long press", bm_list5, NULL);
	new_selector(conf_buttons_lock2_short, "lock button #2 short press", bm_list5, NULL);
	new_selector(conf_buttons_lock2_long, "lock button #2 long press", bm_list5, NULL);
	new_selector(conf_secure_action, "action to perform after pressing secure button", bm_list4, NULL);
	new_selector(conf_secure_power_action, "power button action when device is secured", bm_list3, NULL);

	new_message("If blank is used for power button action there will be no way to lock the screen while secured (dpad center won't work)");

	new_separator();

	new_message("By default the power button will always open ASUI on n800 and open or close it on n810."
				" Always opening ASUI allows the POWER BUTTON + DPAD CENTER combo to always be used to lock the screen."
				" Enabling the first option will always lock&blank the screen and the only way to open ASUI is via the battery applet, ASUI icon or Telescope key combo (see website)."
				" ASUI can always be closed with a swipe from buttons to widgets or the escape key.");
	new_selector(conf_power_action, "power button action when screen is on", bm_list_pa, NULL);

	new_message("Power button will always turn on the screen and unlock it. This setting will cause it to turn on the screen but keep it locked until a secondary key is pressed.");
	new_selector(conf_power_unlock_key, "secondary key to unlock screen with power button", bm_list_puk, NULL);

	new_separator();
}
