//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "main.h"
#include "battery.h"

//////////////////////////////////////////////////////////////////////////

static const char *battery_list4[] = {" percent free ", " percent used ", " free / total ", " used / total ", NULL};

//////////////////////////////////////////////////////////////////////////

void battery_click_callback( GtkWidget *widget, gpointer data ){
	new_section_vbox("Battery"); // add setting widgets to section_content_box

	new_message("The statusbar applet can be a simple button to map ASUI or also show battery status.");
	new_checkbox(conf_enable_battery_applet, "statusbar applet shows battery status", NULL);

	new_separator();

	new_message("Enabling this setting will cause the default statusbar battery applet to display its popup when ASUI is started."
				" This should only happen right after the device is booted, when ASUI crash & restarts and when you enable this setting.");
	new_checkbox(conf_battery_idle_time, "display battery idle time", NULL);
	new_message("The ASUI Battery applet works fine with this enabled.");

	new_separator();

	new_message("The battery widget and usage graph dialog keep track of and display battery usage. Setting this to zero will turn off this feature and avoid memory consumption.");
	new_uint_value(conf_history_days, "days to track battery usage", 0, 7, NULL);

	new_message("Screen, WiFi and Bluetooth on/off events can also be tracked and displayed on the graph.");
	new_checkbox(conf_track_usage_events, "track events", NULL);

	new_separator();

	new_selector(conf_memory_format, "memory display format", battery_list4, NULL);
	new_selector(conf_swap_format, "swap display format", battery_list4, NULL);

	new_separator();

	new_checkbox(conf_temperature_F, "display temperature in Fahrenheit (else Celsius)", NULL);

	if(!file_exists("/sys/power/op_locked")){
		new_separator();
		new_message("Installing the Diablo-Turbo kernel allows ASUI to display DSP clock frequency when active");
	}

	new_separator();
}
