//	Advanced System UI
//	Copyright (c) 2010-2011 Brand Huntsman <brand.huntsman@gmail.com>

#include <stdio.h>
#include <unistd.h>
#ifndef __USE_ISOC99
 #define __USE_ISOC99
#endif
#include <math.h>

#include "window.h"
 #include "draw.h"
#include "text.h"
#include "config.h"

////////////////////////////////////////////////////////////////////////// GLOBALS

unsigned tick_i;

//////////////////////////////////////////////////////////////////////////

void draw_masked_image( s_image *image, int x, int y ){
	XGCValues attr;

	attr.clip_x_origin = x;
	attr.clip_y_origin = y;
	attr.clip_mask = image->mask;
	XChangeGC(window.display, window.gc, GCClipXOrigin | GCClipYOrigin | GCClipMask, &attr);

	XCopyArea(window.display, image->black_pixmap, window.window, window.gc, 0, 0, image->width, image->height, x, y);

	attr.clip_x_origin = 0;
	attr.clip_y_origin = 0;
	attr.clip_mask = 0;
	XChangeGC(window.display, window.gc, GCClipXOrigin | GCClipYOrigin | GCClipMask, &attr);
}

void draw_image( s_image *image, int x, int y ){
	XCopyArea(window.display, (black_theme ? image->black_pixmap : image->white_pixmap), window.window, window.gc, 0, 0, image->width, image->height, x, y);
}

void not_ready( int x, int y ){
	// REMOVE WHEN ALL BUTTONS WORK
	x_set_color(gray_status_color);
	x_draw_line(x, y,    x+63, y+63);
	x_draw_line(x, y+63, x+63, y);
}

////////////////////

void draw_services_indicator( int status, int x, int y, unsigned height ){
	if(status == 2){
		// all services are UP
		x_set_color(green_status_color);
		x_fill_ellipse(x-12, y-12, 23,23);
	} else if(status == 1){
		// some services are UP
		x_set_color(yellow_status_color);
		x_fill_ellipse(x-12, y-12, 23,23);
		x_set_color(gray_status_color);
		x_fill_rectangle(x-53, y-6, 12,12);
		x_set_color(green_status_color);
		x_fill_rectangle(x+37, y-6, 12,12);
		// separator
		x_set_color(line_color);
		x_draw_line(x, y-(height>>1), x, y+(height>>1));
	} else {
		// all services are DOWN
		x_set_color(gray_status_color);
		x_fill_ellipse(x-12, y-12, 23,23);
	}
}

void draw_hardware_indicator( int status, int x, int y ){
	// separator
	x_set_color(line_color);
	x_set_style(2, LineOnOffDash); // dotted line, 2 wide
	x_draw_line(x+199, y+20, x+199, y+80);

	// hardware status rectangle
	x_set_color((status ? red_status_color : gray_status_color));
	x_reset_style();
	x_fill_rectangle(x+25, y+70, 20, (status ? 10 : 5));
}

////////////////////

void draw_tap_markers( int x, int y, int height, unsigned short_tap, unsigned long_tap ){
	if(long_tap){
		// upper left corner
		x_set_color(secondary_selection_color);
//		x_draw_line(x+2, y+2, x+4, y+2); // horizontal
//		x_draw_line(x+2, y+3, x+2, y+4); // vertical
		x_draw_point(x+3, y+3); // center

// TODO: the x_set_style calls elsewhere in the program cause problems with the above x_draw_line calls
		x_draw_point(x+2, y+4); // lower left
		x_draw_point(x+2, y+3);
		x_draw_point(x+2, y+2);
		x_draw_point(x+3, y+2);
		x_draw_point(x+4, y+2); // upper right
	}
	if(short_tap && cfg_short_tap_markers){
		// lower left corner
		x_set_color(selection_color);
		y = y + height - 3;
//		x_draw_line(x+2, y  , x+4, y  ); // horizontal
//		x_draw_line(x+2, y-1, x+2, y-2); // vertical
		x_draw_point(x+3, y-1); // center

// TODO: the x_set_style calls elsewhere in the program cause problems with the above x_draw_line calls
		x_draw_point(x+2, y-2); // upper left
		x_draw_point(x+2, y-1);
		x_draw_point(x+2, y  );
		x_draw_point(x+3, y  );
		x_draw_point(x+4, y  ); // lower right
	}
}

////////////////////

void draw_scrollbar( s_image *image, int x, int y, unsigned position, unsigned min, unsigned max ){
	unsigned p = 300 * ((float)(position - min) / (float)(max - min));

	// scroll bar
	x_set_color(scrollbar_color);
	x_fill_rectangle(x+50, y+34, 300, 3);
	// scroller
	x_set_color(scroller_color);
	x_fill_ellipse(x+40+p, y+14, 21,41);
	// icon
	draw_masked_image(image, x+40+p+2, y+27);

}

unsigned click_scrollbar( int x, unsigned min, unsigned max ){
	if(x < 50) x = 50;
	else if(x > 350) x = 350;

	return ((float)(x-50)/300.0) * (max - min) + min;
}

void draw_step_buttons( int x, int y, unsigned decrement, unsigned increment ){
	x_set_color(innerline_color);
	x_set_style(1, LineOnOffDash); // dotted line
	x_draw_line(x,y+55, x+100,y+55); // top
	x_draw_line(x+50,y+55, x+50,y+99); // middle vertical
	x_draw_line(x+100,y+55, x+100,y+99); // right vertical
	x_reset_style();

	if(decrement) x_set_color(gray_status_color); else x_set_color(innerline_color);
	x_draw_line(x+17,y+78, x+33,y+78); // minus
	if(increment) x_set_color(gray_status_color); else x_set_color(innerline_color);
	x_draw_line(x+67,y+78, x+83,y+78); // plus horizontal
	x_draw_line(x+75,y+70, x+75,y+86); // plus vertical

//	draw_tap_markers(x, y+56, 43, 1, decrement); // short tap only (decrement)
//	draw_tap_markers(x+51, y+56, 43, 1, increment); // short tap only (increment)
}

////////////////////

static unsigned lh, lh_x, lh_y, lh_width, lh_height;
void highlight_long_press( int x, int y, int width, int height ){
	lh = 1; lh_x = x; lh_y = y; lh_width = width; lh_height = height; // save coordinates

	x_set_color(secondary_selection_color);
	x_draw_rectangle(x, y, width-1, height-1);
	x_flush();
	usleep(100000); // display highlight for at least 100ms
}

void unhighlight_long_press( ){
	if(lh){
		x_set_color(bg_color);
		x_draw_rectangle(lh_x, lh_y, lh_width-1, lh_height-1);
		x_flush();
	}
}

void reset_long_press( ){
	lh = 0;
}

////////////////////

void highlight_selected_area( int x, int y, int width, int height ){
	x_set_color(selection_color);
	x_draw_rectangle(x, y, width-1, height-1);
	x_flush();
	usleep(100000); // display highlight for 100ms
	// this usleep also fixes a problem where X wouldn't update the window contents for long periods of time
}

void unhighlight_selected_area( int x, int y, int width, int height ){
	x_set_color(bg_color);
	x_draw_rectangle(x, y, width-1, height-1);
	x_flush();
}

////////////////////

static int tick_x, tick_y;

void init_ticks( int x, int y, XColor *color ){
	tick_x = x;
	tick_y = y;
	tick_i = 0;
	x_set_color(color);
}
void draw_tick( ){
	x_fill_rectangle(tick_x+tick_i*8, tick_y, 4,4);
	x_flush();
	tick_i++;
}

////////////////////

void draw_rss( unsigned size, int x, int y ){
	if(size){
		char buffer[10];
		int w;

		w = (cfg_service_size_unit ? draw_text("MB", 12, fg2_color, x, y, ALIGN_RIGHT, ALIGN_BOTTOM, 0) + 3 : 0);
		snprintf(buffer, sizeof(buffer), "%.1f", roundf(10.0*(float)size/1024.0)/10.0);
		draw_text(buffer, 14, fg1_color, x-w, y, ALIGN_RIGHT, ALIGN_BOTTOM, 0);
	}
}
