//	Advanced System UI
//	Copyright (c) 2010-2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"

//////////////////////////////////////////////////////////////////////////

void draw_edit_widgets_button( unsigned force, int x, int y ){
	if(force){
		// background for all buttons is cleared by draw_window()
//	} else if(/* condition */){
//		// button background
//		x_set_color(bg_color);
//		x_fill_rectangle(x, y, 80, 80);
	} else return;

	unsigned cx = x+40, cy = y+40;

	draw_text("edit", 16, fg2_color, cx, cy-6, ALIGN_CENTER, ALIGN_BASELINE, 0);
	draw_text("widgets", 16, fg2_color, cx, cy+18, ALIGN_CENTER, ALIGN_BASELINE, 0);

	draw_tap_markers(x, y, 80, 1, 0); // short tap only
}

//////////////////////////////////////////////////////////////////////////

void click_edit_widgets_button( ){
	if(click.type != CLICK_SHORT) return;

	highlight_selected_area(widget_x, widget_y, 80,80);
	widget_edit_mode = 1;
	selected_cell.widget_cell = NULL;

	// redraw window in widget edit mode
	draw_window(1);
}

////////////////////////////////////////////////////////////////////////// BUTTON

s_button button_edit_widgets = {"#widgets", "/apps/asui_state/bcell_edit_widgets", draw_edit_widgets_button, click_edit_widgets_button, 0};
