//	Advanced System UI
//	Copyright (c) 2010-2011 Brand Huntsman <brand.huntsman@gmail.com>

#include <stdio.h>
#include <unistd.h>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"
#include "services.h"
#include "hardware.h"

//////////////////////////////////////////////////////////////////////////

static unsigned ticks_visible;

void draw_bluetooth_widget( unsigned force, int x, int y ){
	if(force){
		// background for all widgets is cleared by draw_window()
		bluetooth_widget_page = primary_widgets;
	} else if(hw_changes & HW_BLUETOOTH || svc_changes & SVC_BLUETOOTH){
		// widget background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 399, 99);
	} else return;

	draw_text("Bluetooth", 32, fg1_color, x+20, y+50, ALIGN_LEFT, ALIGN_MIDDLE, 0);
	draw_hardware_indicator(hw_bluetooth.enabled, x, y);
	draw_services_indicator(svc_bluetooth_status, x+299, y+50, 60);
	draw_rss(svc_bluetooth_size, x+390, y+90);

	draw_tap_markers(x, y, 99, 1, 1); // short & long taps (enable & device dialog)
	draw_tap_markers(x+200, y, 99, 1, 0); // short tap only (services)

	// device name and number of connections
	if(hw_bluetooth.enabled){
		int w = 0;

		if(hw_bluetooth.visible)
			w = draw_text("*", 36, selection_color, x+20, y+15, ALIGN_LEFT, ALIGN_TOP, 0) + 3;

		if(hw_bluetooth.name)
			draw_text(hw_bluetooth.name, 16, fg1_color, x+20+w, y+15, ALIGN_LEFT, ALIGN_TOP, 170-w);

		if(hw_bluetooth.nr_devices){
			char buffer[20];
			snprintf(buffer, sizeof(buffer), "%u  Connected", hw_bluetooth.nr_devices);
			draw_text(buffer, 16, red_status_color, x+60, y+70, ALIGN_LEFT, ALIGN_TOP, 0);
		}

		// blue arrow to indicate swipe feature
		x_set_color(selection_color);
		x_draw_line(x+185,y+90, x+215,y+90);
		x_draw_line(x+185,y+90, x+195,y+85);
		x_draw_line(x+185,y+90, x+195,y+95);
	}

	ticks_visible = 0;
}

//////////////////////////////////////////////////////////////////////////

static s_tap_throttler bluetooth_throttle;

void click_bluetooth_widget( ){
	if(click.type == CLICK_DOWN || click.type == CLICK_MOTION) return; // no drag support

	if(click.type == CLICK_DRAG){
		if(hw_bluetooth.enabled && click.x >= 200 && click.x + click.offset_x < 200){
			// toggle bluetooth visibility
			highlight_selected_area(widget_x, widget_y, 399, 99);
			hw_set_bluetooth_visible(!hw_bluetooth.visible);
			unhighlight_selected_area(widget_x, widget_y, 399, 99);
		}
	} else if(click.x >= 200){

		if(click.type != CLICK_SHORT) return; // no long press support

		// require double tap if enabled and service is fully started or stopped
		// partial state always uses a single tap
		if(svc_bluetooth_status != 1)
			if(!get_double_tap(Z_MAIN_SVC_BLUETOOTH)) return;

		if(throttle_taps(&bluetooth_throttle)) return;

		{
			if(svc_bluetooth_status == 1 && click.x >= 300){
				highlight_selected_area(widget_x+300, widget_y, 99, 99);
				svc_bluetooth_status = 0; // attempt to start services
			} else
				highlight_selected_area(widget_x+200, widget_y, (svc_bluetooth_status == 1 ? 99 : 199), 99);

			if(svc_bluetooth_status)
				svc_init_bluetooth(SVC_STOP, 0);
			else {
				init_ticks(widget_x+266, widget_y+20, gray_status_color);
				svc_init_bluetooth(SVC_START, 1); // display ticks

				// give services 8 seconds to start
				unsigned i; for(i = 0; i < 8; i++){ draw_tick(); sleep(1); }
			}

			svc_changes |= SVC_BLUETOOTH;
			draw_bluetooth_widget(0, widget_x, widget_y); // update service dot
		}

		finalize_tap(bluetooth_throttle);

	} else if(click.type == CLICK_HOLD){

		// highlight to indicate long press
		highlight_long_press(widget_x, widget_y, 198, 99);

	} else if(hw_bluetooth.enabled){

		if(click.type == CLICK_SHORT){

			if(throttle_taps(&bluetooth_throttle)) return;

			// turn off hardware
			highlight_selected_area(widget_x, widget_y, 198, 99);
			hw_set_bluetooth(0);
			// highlight will be cleared when client receives off signal

			finalize_tap(bluetooth_throttle);

		} else {

			// open bluetooth search dialog
			highlight_selected_area(widget_x, widget_y, 198, 99);
			hw_bluetooth_open_search();
			unhighlight_selected_area(widget_x, widget_y, 198, 99);

		}

	} else {

		if(throttle_taps(&bluetooth_throttle)) return;

		{
			unsigned i;

			if(ticks_visible){
				hw_changes |= HW_BLUETOOTH;
				draw_bluetooth_widget(0, widget_x, widget_y); // ticks are still visible from a failed connection attempt, clear them
			}

			highlight_selected_area(widget_x, widget_y, 198, 99);

			// enable normal mode
			if(hw_flight_mode){
				mce_normal_mode();
				draw_window(0); // update flight mode icon

				// restore highlight (just in case)
				highlight_selected_area(widget_x, widget_y, 198, 99);
			}

			if(svc_bluetooth_status != 2){
				// starting services takes a bit, display ticks
				init_ticks(widget_x+266, widget_y+20, red_status_color);

				// start services before enabling hardware
				svc_init_bluetooth(SVC_START, 1); // display ticks
				if(svc_bluetooth_status != 2){
					// failed to start services
					hw_changes |= HW_BLUETOOTH;
					svc_changes |= SVC_BLUETOOTH;
					draw_bluetooth_widget(0, widget_x, widget_y);
					finalize_tap(bluetooth_throttle);
					return;
				}

				// give services 8 seconds to start
				for(i = 0; i < 8; i++){
					draw_tick();
					sleep(1);
				}

				svc_changes |= SVC_BLUETOOTH;
				draw_bluetooth_widget(0, widget_x, widget_y); // update service dot

				// restore highlight
				highlight_selected_area(widget_x, widget_y, 198, 99);
			}

			// display a couple ticks
			init_ticks(widget_x+60, widget_y+71, red_status_color);
			for(i = 0; i < 3; i++){
				hw_set_bluetooth(1); // turn on the hardware
				draw_tick();
				sleep(1);
			}
			ticks_visible = 1;

			if(click.type == CLICK_LONG)
				hw_bluetooth_open_search(); // open bluetooth search dialog

			// ticks will clear and hardware mark will light up when client receives connectable signal
			unhighlight_selected_area(widget_x, widget_y, 198, 99);
		}

		finalize_tap(bluetooth_throttle);

	}
}

////////////////////////////////////////////////////////////////////////// WIDGET

s_widget widget_bluetooth = {"Bluetooth", "/apps/asui_state/cell_bluetooth", FULL_WIDGET, draw_bluetooth_widget, click_bluetooth_widget, 0};
