//	Advanced System UI
//	Copyright (c) 2010-2011 Brand Huntsman <brand.huntsman@gmail.com>

// seconds (double)
#define INITIAL_REFRESH_PERIOD 1.0
#define REFRESH_PERIOD 5.0
#define SCROLL_UPDATE_PERIOD 0.100

#include <stdio.h>
//#include <string.h>
//#include <unistd.h>
//#ifndef __USE_ISOC99
// #define __USE_ISOC99
//#endif
//#include <math.h>
//#include <signal.h>
//#include <sys/types.h>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"
//#include "services.h"
#include "hardware.h"
//#include "dialog.h"
 #include "widget_battery.h"

#include "battery_graph.h"
#include "procviewer.h"
#include "governor_dsp.h"

//////////////////////////////////////////////////////////////////////////

static XColor *get_drain_rate_color( float rate ){
	// 10 days = 0.4% /hour
	// 5 days  = 0.8% /hour
	// 7 hours = 14%  /hour
	// 4 hours = 25%  /hour

	if(rate >= 14.0) return red_status_color;
	if(rate > 0.8) return yellow_status_color;
	if(rate >= 0.4) return green_status_color;
	return fg1_color; // this is only possible when charging reduces the drain
}

static void draw_mem_indicator( int x, int y, unsigned used ){
	if(used){
		// red minus
		draw_text("-", 20, red_status_color, x-5, y, ALIGN_RIGHT, ALIGN_TOP, 0);
	} else {
		// green plus
		draw_text("+", 15, green_status_color, x-5, y, ALIGN_RIGHT, ALIGN_TOP, 0);
	}
}

// FORMAT: 0:percent free, 1:percent used, 2:free/total, 3:used/total
static void draw_mem_format( char *name, unsigned free, unsigned total, unsigned format, int x, int y ){
	char buffer[10];

	draw_text(name, 16, fg2_color, x+246, y+10, ALIGN_CENTER, ALIGN_TOP, 0);

	unsigned is_used = (format == 1 || format == 3 ? 1 : 0);
	unsigned numerator = (is_used ? total-free : free);
	XColor *ram_color;
	unsigned pct = 100*numerator/total;
	int w;

	if(is_used){
		// used
		if(pct < 70) ram_color = fg1_color;						// white  - 0-69% used
		else if(pct < 90) ram_color = yellow_status_color;		// yellow - 70-89% used
		else ram_color = red_status_color;						// red    - 90-100% used
	} else {
		// free
		if(pct > 30) ram_color = fg1_color;						// white  - 31-100% free
		else if(pct > 10) ram_color = yellow_status_color;		// yellow - 11-30% free
		else ram_color = red_status_color;						// red    - 0-10% free
	}
	#define UNDERLINE_OFFSET 3
	if(format == 0 || format == 1){
		// draw percentage free:0 or used:1
		snprintf(buffer, sizeof(buffer), "%u%%", pct);
		w = draw_text(buffer, 20, ram_color, x+246, y+30, ALIGN_CENTER, ALIGN_TOP, 0)>>1;
		draw_mem_indicator(x+246-w, y+30, is_used);
	} else {
		// draw free:2 or used:3 over total
		snprintf(buffer, sizeof(buffer), "%d", numerator/1024); w = draw_text(buffer, 20, ram_color, x+245, y+28, ALIGN_RIGHT, ALIGN_TOP, 0);
		draw_mem_indicator(x+245-w, y+28, is_used);
		snprintf(buffer, sizeof(buffer), "%d", total/1024); draw_text(buffer, 18, fg2_color, x+247, y+50, ALIGN_LEFT, ALIGN_TOP, 0);
		x_set_color(fg2_color);
		x_draw_line(x+220, y+55, x+272, y+35);
	}
}

//////////////////////////////////////////////////////////////////////////

static unsigned show_swap = 0;

static int battery_widget_x, battery_widget_y;

void draw_battery_widget( unsigned force, int x, int y ){
	if(force){
		// background for all widgets is cleared by draw_window()
		if(!drawing_popup_window){
			// don't save values if drawing the popup window
			battery_widget_page = primary_widgets;
			battery_widget_x = x;
			battery_widget_y = y;
		}
	} else if(hw_device_locked){
		if(!(hw_changes & DEVLOCK_BATTERY_FLAGS)) return;
		x = battery_widget_x;
		y = battery_widget_y;
		// widget background on secure keypad
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 199, 99);
	} else if(hw_changes & ALL_BATTERY_FLAGS){
		x = battery_widget_x;
		y = battery_widget_y;
		// widget background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 399, 99);
	} else return;

	char buffer[50];

	{
		char *title; XColor *title_color, *pct_color;
		int w, title_size, pct_size, xoff, yoff, y_base;
		switch(hw_battery.status){
		case BATTERY_DRAINING:	title = "Battery";  title_color = fg2_color;          pct_size = 26; pct_color = fg1_color; xoff = 4; yoff = 0; break;
		case BATTERY_CHARGING:	title = "Charging"; title_color = green_status_color; pct_size = 22; pct_color = fg2_color; xoff = 0; yoff = 4; break;
		default: /*BATTERY_AC*/	title = "Charged";  title_color = green_status_color; pct_size = 26; pct_color = fg1_color; xoff = 0; yoff = 0; break;
		}
		if(hw_device_locked){ title_size = 22; pct_size -= 4; y_base = y+20; } else { title_size = 26; y_base = y+16; }

		// status and percentage
		w = draw_text(title, title_size, title_color, x+12, y_base, ALIGN_LEFT, ALIGN_TOP, 0);
		if(hw_battery.capacity < 100.0)
			snprintf(buffer, sizeof(buffer), "%.1f%%", hw_battery.capacity);
		else
			sprintf(buffer, "100%%");
		draw_text(buffer, pct_size, pct_color, x+12+w+10+xoff, y_base+yoff, ALIGN_LEFT, ALIGN_TOP, 0);

		// green line under "Charged"
		if(hw_battery.status == BATTERY_AC){
			x_set_color(title_color);
			x_set_style(1, LineOnOffDash); // dotted line
			x_draw_rectangle(x+12-5,y_base-5, w+9,title_size+7);
			x_reset_style();
		}
	}
	if(!hw_device_locked){
		if(cfg_battery_usage){
			int w;

			#define OFFSET_LABEL 85
			#define OFFSET_RATE 97
			#define OFFSET_UNKNOWN 105

			// last hour
			draw_text("last hour:", 16, fg2_color, x+OFFSET_LABEL, y+62, ALIGN_RIGHT, ALIGN_BASELINE, 0);
			if(hw_battery.drain1){
				int offset = x+OFFSET_RATE+(hw_battery.hours1 ? 0 : -7);
				snprintf(buffer, sizeof(buffer), "%s%.1f", (hw_battery.hours1 ? "" : "~"), hw_battery.drain1);
				w = draw_text(buffer, 18, get_drain_rate_color(hw_battery.drain1), offset, y+62, ALIGN_LEFT, ALIGN_BASELINE, 0);
				draw_text(" % /hour", 14, fg2_color, offset+w, y+62, ALIGN_LEFT, ALIGN_BASELINE, 0);
			} else
				draw_text("waiting...", 16, fg2_color, x+OFFSET_UNKNOWN, y+62, ALIGN_LEFT, ALIGN_BASELINE, 0);

			// last 24 hours
			snprintf(buffer, sizeof(buffer), "last %uh:", hw_battery.hours24);
			draw_text(buffer, 16, fg2_color, x+OFFSET_LABEL, y+85, ALIGN_RIGHT, ALIGN_BASELINE, 0);
			if(hw_battery.drain24){
				snprintf(buffer, sizeof(buffer), "%.1f", hw_battery.drain24);
				w = draw_text(buffer, 18, get_drain_rate_color(hw_battery.drain24), x+OFFSET_RATE, y+85, ALIGN_LEFT, ALIGN_BASELINE, 0);
				draw_text(" % /hour", 14, fg2_color, x+OFFSET_RATE+w, y+85, ALIGN_LEFT, ALIGN_BASELINE, 0);
			} else
				draw_text("waiting...", 16, fg2_color, x+OFFSET_UNKNOWN, y+85, ALIGN_LEFT, ALIGN_BASELINE, 0);
		} else {
			int minutes = hw_battery.active_minutes;

			// active time
			if(minutes > 60){
				int hours = minutes / 60;
				XColor *color = (hours > 2 ? fg1_color : yellow_status_color); // yellow @ 2 hours or less
				snprintf(buffer, sizeof(buffer), "%d hours", hours);
				draw_text("active:", 16, fg2_color, x+65, y+62, ALIGN_RIGHT, ALIGN_BASELINE, 0);
				draw_text(buffer, 16, color, x+75, y+62, ALIGN_LEFT, ALIGN_BASELINE, 0);
			} else {
				snprintf(buffer, sizeof(buffer), "less than %d minutes", minutes); // red @ 1 hour or less
				draw_text(buffer, 16, red_status_color, x+100, y+62, ALIGN_CENTER, ALIGN_BASELINE, 0);
			}

			if(cfg_battery_idle_time){
				int days, hours, minutes = hw_battery.idle_minutes;

				// idle time
				draw_text("idle:", 16, fg2_color, x+65, y+85, ALIGN_RIGHT, ALIGN_BASELINE, 0);
				if(minutes > 1440){
					days = minutes / 1440;
					hours = (minutes - days * 1440) / 60;
					if(hours)
						snprintf(buffer, sizeof(buffer), "%d day%s %d hour%s", days, (days > 1 ? "s" : ""), hours, (hours > 1 ? "s" : ""));
					else
						snprintf(buffer, sizeof(buffer), "%d day%s", days, (days > 1 ? "s" : ""));
				} else {
					hours = minutes / 60;
					snprintf(buffer, sizeof(buffer), "%d hour%s", hours, (hours > 1 ? "s" : ""));
				}
				draw_text(buffer, 16, fg2_color, x+75, y+85, ALIGN_LEFT, ALIGN_BASELINE, 0);
			}
		}

		draw_tap_markers(x, y, 99, 1, cfg_history_days); // short and long tap
	}

	////////////////////

	if(!hw_device_locked && !use_minimal_ui){
		x_set_color(line_color);
		x_draw_line(x+199, y, x+199, y+99);

		// memory or swap usage
		if(hw_swap.total && show_swap && !drawing_popup_window)
			draw_mem_format("swap", hw_swap.free, hw_swap.total, cfg_swap_format, x, y);
		else
			draw_mem_format("memory", hw_memory.free, hw_memory.total, cfg_memory_format, x, y);

		// cpu usage
			if(!drawing_popup_window){
			snprintf(buffer, sizeof(buffer), "%u%% cpu", hw_cpu.usage);
			draw_text(buffer, (hw_cpu.usage > 33 ? 20 : 18),
				(hw_cpu.usage > 50 ? red_status_color : (hw_cpu.usage ? yellow_status_color : fg2_color)),
				x+246, y+92, ALIGN_CENTER, ALIGN_BOTTOM, 0);
		}

		if(!drawing_popup_window) draw_tap_markers(x+201, y, 99, 1, hw_swap.total); // short tap only (long tap if swap is enabled)

		x_set_color(line_color);
		x_draw_line(x+292, y, x+292, y+99);
	}

	////////////////////

	if(!hw_device_locked && !use_minimal_ui){
		// cpu frequency
		snprintf(buffer, sizeof(buffer), "%dMHz", hw_cpu.frequency);
		draw_text(buffer, 20, (hw_cpu.frequency == 165 ? fg2_color : (hw_cpu.frequency >= 400 ? red_status_color : yellow_status_color)),
			x+380, y+20, ALIGN_RIGHT, ALIGN_TOP, 0);

		if(hw_cpu.dsp_frequency){
			// DSP frequency
			snprintf(buffer, sizeof(buffer), "DSP %dMHz", hw_cpu.dsp_frequency);
			draw_text(buffer, 12, fg1_color, x+380, y+45, ALIGN_RIGHT, ALIGN_MIDDLE, 0);
		} else if(hw_cpu.current_governor){
			// governor name
			draw_text(hw_cpu.current_governor->name, 14, fg1_color, x+380, y+45, ALIGN_RIGHT, ALIGN_MIDDLE, 0);
		}

		if(!drawing_popup_window) draw_tap_markers(x+293, y, 99, 0, 1); // long tap only
	}
	{
		// temperature
		snprintf(buffer, sizeof(buffer), "%.1f %c", (cfg_temperature_F ? hw_sensors.temperature * 1.8 + 32 : hw_sensors.temperature),
				(cfg_temperature_F ? 'F' : 'C'));
		draw_text(buffer, 20, fg2_color, x+(hw_device_locked ? 12 : 380), y+(use_minimal_ui ? 55 : 80), (hw_device_locked ? ALIGN_LEFT : ALIGN_RIGHT), ALIGN_BOTTOM, 0);
	}
}

//////////////////////////////////////////////////////////////////////////

static s_tap_throttler battery_throttle;

void click_battery_widget( ){
	if(click.x > 292){
		// open governor selector

		if(click.type == CLICK_HOLD){

			// highlight to indicate long press
			highlight_long_press(widget_x+293, widget_y, 106,99);

		} else if(click.type == CLICK_LONG){

			if(throttle_taps(&dialog_throttle)) return;

			highlight_selected_area(widget_x+293, widget_y, 106, 99);
			governor_open_dialog();

			finalize_tap(dialog_throttle);

		}

	} else if(click.x > 199){
		// open process list

		if(hw_swap.total && click.type == CLICK_HOLD){

			// highlight to indicate long press
			highlight_long_press(widget_x+200, widget_y, 92, 99);

		} else if(hw_swap.total && click.type == CLICK_LONG){

			if(throttle_taps(&dialog_throttle)) return;

			highlight_selected_area(widget_x+200, widget_y, 92, 99);
			show_swap = (show_swap ? 0 : 1); // toggle between swap and memory display

			hw_changes |= HW_MEMORY;
			draw_battery_widget(0, 0, 0);
			hw_changes &= ~ALL_BATTERY_FLAGS;
			x_flush();

			finalize_tap(dialog_throttle);

		} else if(click.type == CLICK_SHORT){

			if(throttle_taps(&dialog_throttle)) return;

			highlight_selected_area(widget_x+200, widget_y, 92, 99);
			procviewer_open_dialog();

			finalize_tap(dialog_throttle);
		}

	} else if(cfg_history_days){
		// battery stats -- toggle active/idle and drain rate

		if(click.type == CLICK_HOLD){

			// highlight to indicate long press
			highlight_long_press(widget_x, widget_y, 199, 99);

		} else if(click.type == CLICK_LONG){

			if(throttle_taps(&dialog_throttle)) return;

			highlight_selected_area(widget_x, widget_y, 199, 99);
			battery_graph_open_dialog();

			finalize_tap(dialog_throttle);

		} else if(click.type == CLICK_SHORT){

			if(throttle_taps(&battery_throttle)) return;

			highlight_selected_area(widget_x, widget_y, 199, 99);
			cfg_battery_usage = (cfg_battery_usage ? 0 : 1); // toggle between drain rate and active/idle display
			conf_set_bool(conf_battery_usage, cfg_battery_usage);

			hw_changes |= HW_BATTERY;
			draw_battery_widget(0, 0, 0);
			hw_changes &= ~ALL_BATTERY_FLAGS;
			x_flush();

			finalize_tap(battery_throttle);
		}

	}
}

////////////////////////////////////////////////////////////////////////// WIDGET

s_widget widget_battery = {"Battery", "/apps/asui_state/cell_battery", FULL_WIDGET, draw_battery_widget, click_battery_widget, 0};
