//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "main.h"
#include "rbv_keys.h"

//////////////////////////////////////////////////////////////////////////

static GtkWidget *rotate_selector, *brightness_selector, *volume_selector;

static void select_rbv_key( GtkComboBox *widget, gpointer data ); // prototype
static void reload_selector( GtkWidget *widget, const char *conf ){
	gtk_signal_disconnect_by_func(GTK_OBJECT(widget), GTK_SIGNAL_FUNC(select_rbv_key), (void *)conf);
	gtk_combo_box_set_active(GTK_COMBO_BOX(widget), conf_get_int(conf));
	gtk_signal_connect(GTK_OBJECT(widget), "changed", GTK_SIGNAL_FUNC(select_rbv_key), (void *)conf);
}
static void select_rbv_key( GtkComboBox *widget, gpointer data ){
	int index = gtk_combo_box_get_active(widget);
	conf_set_int((const char *)data, (index >= 0 ? index : 0));

	// sleep, let ASUI process the signal and then reload page to get new values
	sleep(1);
	reload_selector(rotate_selector, conf_buttons_rotate);
	reload_selector(brightness_selector, conf_buttons_brightness);
	reload_selector(volume_selector, conf_buttons_volume);
}

static const char *rbv_list4[] = {" not bound ", " PLUS / MINUS ", " UP / DOWN ", " RIGHT / LEFT ", NULL};

//////////////////////////////////////////////////////////////////////////

static void change_step_value( GObject *gobject, GParamSpec *arg1, gpointer user_data ){
	if(strcmp(arg1->name, "value")) return;
	int value;
	g_object_get(gobject, "value", &value, NULL);
	if(value > 0) conf_set_int((const char *)user_data, value);
}
static void new_step_value( const char *conf, char *name ){
	unsigned one_step = (conf == conf_buttons_brightness_step && !conf_get_bool(conf_brightness_enhanced) ? 1 : 0);
	// hbox
	GtkWidget *hbox = gtk_hbox_new(FALSE, 10);
	gtk_box_pack_start(GTK_BOX(section_content_box), hbox, FALSE, FALSE, 10);
	gtk_widget_show(hbox);
	// numeric entry with arrows
	GtkWidget *editor = hildon_number_editor_new(1, (one_step ? 1 : 20));
	hildon_number_editor_set_value((HildonNumberEditor *)editor, conf_get_int(conf));
	gtk_signal_connect(GTK_OBJECT(editor), "notify", GTK_SIGNAL_FUNC(change_step_value), (void *)conf);
	gtk_box_pack_start(GTK_BOX(hbox), editor, FALSE, FALSE, 20);
	gtk_widget_show(editor);
	// label
	GtkWidget *label = gtk_label_new(name);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	if(one_step) gtk_widget_set_sensitive(hbox, FALSE);
}

//////////////////////////////////////////////////////////////////////////

void rbv_keys_click_callback( GtkWidget *widget, gpointer data ){
	new_section_vbox("RBV Keys"); // add setting widgets to section_content_box

	rotate_selector = new_selector(conf_buttons_rotate, "rotation", rbv_list4, select_rbv_key);

	new_separator();

	brightness_selector = new_selector(conf_buttons_brightness, "brightness", rbv_list4, select_rbv_key);
	new_step_value(conf_buttons_brightness_step, "brightness steps [requires enhanced brightness]");

	new_separator();

	volume_selector = new_selector(conf_buttons_volume, "volume", rbv_list4, select_rbv_key);
	new_step_value(conf_buttons_volume_step, "volume steps");

	new_separator();
}
