//	Advanced System UI
//	Copyright (c) 2010-2011 Brand Huntsman <brand.huntsman@gmail.com>

#include <stdio.h>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "hardware.h"
#include "dialog.h"
 #include "governor_dsp.h"

////////////////////////////////////////////////////////////////////////// LOCALS

static unsigned waiting_on_governors;

//////////////////////////////////////////////////////////////////////////

static void draw_governor_dsp( unsigned force ){
	// force is not needed

	// dialog background
	x_set_color(bg_color);
	x_fill_rectangle(0, 0, window.width, window.height);

	int y, cpu_x, dsp_x, dsp_y;
	if(window.width > window.height){
		// landscape
		cpu_x = 50+150;
		dsp_x = 450+150;
		dsp_y = 0;
	} else {
		// portrait
		cpu_x = dsp_x = window.width>>1;
		dsp_y = 400;
	}

	// governors
	s_hw_governor *g;
	draw_text("CPU Policy", 24, fg1_color, cpu_x, 20, ALIGN_CENTER, ALIGN_TOP, 0);
	if(hw_cpu.governor_list){
		for(g = hw_cpu.governor_list, y = 50; g != NULL; g = g->next, y += 70){
			x_set_color((g == hw_cpu.current_governor ? green_status_color : fg2_color));
			x_draw_rectangle(cpu_x-150, y, 300,60);
			draw_text(g->name, 18, (g == hw_cpu.current_governor ? green_status_color : fg2_color), cpu_x, y+30, ALIGN_CENTER, ALIGN_MIDDLE, 0);
		}
		waiting_on_governors = 0;
	} else {
		draw_text("...governor list hasn't loaded yet...", 18, red_status_color, cpu_x, 240, ALIGN_CENTER, ALIGN_MIDDLE, 0);
		waiting_on_governors = 1;
	}

	// DSP clock ratios
	s_hw_dsp_clock *clock;
	draw_text("CPU / DSP MHz", 24, fg1_color, dsp_x, dsp_y+20, ALIGN_CENTER, ALIGN_TOP, 0);
	if(hw_cpu.dsp_clocks){
		unsigned op_locked = get_file_value("/sys/power/op_locked");
		unsigned ratio = 0, current_ratio = get_file_value("/sys/power/op_dsp");
		for(clock = hw_cpu.dsp_clocks, y = dsp_y+50; clock != NULL; clock = clock->next, y += 70, ratio++){
			char buffer[30];
			snprintf(buffer, sizeof(buffer), "%u / %u", clock->cpu, clock->dsp);
			x_set_color((ratio == current_ratio ? (op_locked ? red_status_color : green_status_color) : fg2_color));
			x_draw_rectangle(dsp_x-150, y, 300,60);
			draw_text(buffer, 18, (ratio == current_ratio ? (op_locked ? red_status_color : green_status_color) : fg2_color),
						dsp_x, y+30, ALIGN_CENTER, ALIGN_MIDDLE, 0);
		}
	} else {
		draw_text("...install Diablo-Turbo...", 18, red_status_color, dsp_x, dsp_y+220, ALIGN_CENTER, ALIGN_MIDDLE, 0);
		draw_text("330 / 220", 18, green_status_color, dsp_x, dsp_y+260, ALIGN_CENTER, ALIGN_MIDDLE, 0);
	}

	// close button
	x_set_color(line_color);
	int x = window.width-240; y = window.height-60;
	x_draw_line(x, y, window.width, y);
	x_draw_line(x, y, x, window.height);
	draw_text("Close", 24, fg2_color, window.width-120, window.height-20, ALIGN_CENTER, ALIGN_BASELINE, 0);

	hw_changes = 0;
}

static void click_governor_dsp( ){
	if(click.type != CLICK_SHORT) return; // no long press or drag support

	int y, cpu_x, dsp_x, dsp_y;
	if(window.width > window.height){
		// landscape
		cpu_x = 50+150;
		dsp_x = 450+150;
		dsp_y = 0;
	} else {
		// portrait
		cpu_x = dsp_x = window.width>>1;
		dsp_y = 400;
	}

	// governors
	if(!waiting_on_governors){
		s_hw_governor *g;
		for(g = hw_cpu.governor_list, y = 50; g != NULL; g = g->next, y += 70){
			if(click.y >= y && click.y <= y+60 && click.x >= cpu_x-150 && click.x <= cpu_x+150){
				if(g != hw_cpu.current_governor){
					highlight_selected_area(cpu_x-150, y, 301,61);
					hw_set_governor(g);
					draw_governor_dsp(1);
				}
				return;
			}
		}
	}

	// DSP clock ratios
	if(!get_file_value("/sys/power/op_locked")){
		unsigned ratio = 0, current_ratio = get_file_value("/sys/power/op_dsp");
		s_hw_dsp_clock *clock;
		for(clock = hw_cpu.dsp_clocks, y = dsp_y+50; clock != NULL; clock = clock->next, y += 70, ratio++){
			if(click.y >= y && click.y <= y+60 && click.x >= dsp_x-150 && click.x <= dsp_x+150){
				if(ratio != current_ratio){
					highlight_selected_area(dsp_x-150, y, 301,61);
					hw_set_dsp_ratio(ratio);
					draw_governor_dsp(1);
				}
				return;
			}
		}
	}

	// close button
	if(click.y > (int)window.height-60 && click.x > (int)window.width-240){
		highlight_selected_area(window.width-240, window.height-60, 240,60);
		dialog_close();
	}
}

static void keypress_governor_dsp( ){
	switch(keypress.keycode){
	case KEYCODE_ESCAPE:
		// close dialog
		if(keypress.type == KEY_SHORT){
			highlight_selected_area(window.width-240, window.height-60, 240,60);
			dialog_close();
		}
		break;
	default:
		if(!dpadlock_keypress_handler())
			brv_keypress_handler();
				// ignore all other keys
		break;
	}
}

//////////////////////////////////////////////////////////////////////////

void governor_open_dialog( ){
	dialog_open(draw_governor_dsp, click_governor_dsp, keypress_governor_dsp, NULL, DLG_REDRAW_OFF); // no redraw
}
