//	Advanced System UI
//	Copyright (c) 2010-2011 Brand Huntsman <brand.huntsman@gmail.com>

#include <stdlib.h>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"
#include "hardware.h"
#include "dialog.h"

//////////////////////////////////////////////////////////////////////////

static unsigned rebooting;

static void draw_the_end( unsigned force ){
	// force is not needed

	// dialog background
	x_set_color(bg_color);
	x_fill_rectangle(0, 0, window.width, window.height);

	draw_text((rebooting ? "rebooting..." : "shutting down..."), 48, fg1_color, window.width>>1, window.height>>1, ALIGN_CENTER, ALIGN_MIDDLE, 0);
}

void reboot_handler( ){
	dialog_close();
	rebooting = 1;
	dialog_open(draw_the_end, NULL, NULL, NULL, DLG_REDRAW_OFF); // no clicks, keys or redraw

	debug_write("reboot requested");

	mce_reboot();
}

void shutdown_handler( ){
	dialog_close();
	rebooting = 0;
	dialog_open(draw_the_end, NULL, NULL, NULL, DLG_REDRAW_OFF); // no clicks, keys or redraw

	debug_write("shutdown requested");

//	if(file_exists("/etc/rc5.d/K45advanced-systemui"))
//		system("/etc/init.d/osso-systemui start"); // start SystemUI to display charging indicator

	mce_shutdown();
}

//////////////////////////////////////////////////////////////////////////

void draw_reboot_button( unsigned force, int x, int y ){
	if(force){
		// background for all buttons is cleared by draw_window()
//	} else if(/* condition */){
//		// button background
//		x_set_color(bg_color);
//		x_fill_rectangle(x, y, 80, 80);
	} else return;

	draw_image(&im_reboot, x+8, y+8);

	draw_tap_markers(x, y, 80, 1, 0); // short tap only
}

void draw_shutdown_button( unsigned force, int x, int y ){
	if(force){
		// background for all buttons is cleared by draw_window()
//	} else if(/* condition */){
//		// button background
//		x_set_color(bg_color);
//		x_fill_rectangle(x, y, 80, 80);
	} else return;

	draw_image(&im_shutdown, x+8, y+8);

	draw_tap_markers(x, y, 80, 1, 0); // short tap only
}

//////////////////////////////////////////////////////////////////////////

void click_reboot_button( ){
	if(click.type != CLICK_SHORT) return;

	if(throttle_taps(&dialog_throttle)) return;

	highlight_selected_area(widget_x, widget_y, 80,80);
	yes_color = red_status_color;
	open_confirmation_dialog("Reboot the device?", reboot_handler, 36);

	finalize_tap(dialog_throttle);

	// highlight removed by dialog
}

void click_shutdown_button( ){
	if(click.type != CLICK_SHORT) return;

	if(throttle_taps(&dialog_throttle)) return;

	highlight_selected_area(widget_x, widget_y, 80,80);
	yes_color = red_status_color;
	open_confirmation_dialog("Shutdown the device?", shutdown_handler, 36);

	finalize_tap(dialog_throttle);

	// highlight removed by dialog
}

////////////////////////////////////////////////////////////////////////// BUTTON

s_button button_reboot = {"reboot", "/apps/asui_state/bcell_reboot", draw_reboot_button, click_reboot_button, 0};
s_button button_shutdown = {"shutdown", "/apps/asui_state/bcell_shutdown", draw_shutdown_button, click_shutdown_button, 0};
