//	Advanced System UI
//	Copyright (c) 2010 Brand Huntsman <brand.huntsman@gmail.com>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"
#include "services.h"

//////////////////////////////////////////////////////////////////////////

void draw_vpn_widget( unsigned force, int x, int y ){
	if(force){
		// background for all widgets is cleared by draw_window()
	} else if(svc_changes & SVC_VPN){
		// widget background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 199, 99);
	} else return;

	draw_text("OpenVPN", 28, fg2_color, x+99, y+20, ALIGN_CENTER, ALIGN_TOP, 0);
	if(svc_vpn_installed){
		draw_services_indicator(svc_vpn_status, x+99, y+70, 50);
		draw_rss(svc_vpn_size, x+190, y+90);

		draw_tap_markers(x, y, 99, 1, 0); // short tap only
	} else
		draw_text("not installed", 16, fg2_color, x+99, y+65, ALIGN_CENTER, ALIGN_MIDDLE, 0);
}

//////////////////////////////////////////////////////////////////////////

static s_tap_throttler vpn_throttle;

void click_vpn_widget( ){
	if(svc_vpn_installed){
		if(click.type != CLICK_SHORT) return; // no long press or drag support

		// require double tap if enabled
		if(!get_double_tap(Z_MAIN_SVC_VPN)) return;

		if(throttle_taps(&vpn_throttle)) return;

		{
			highlight_selected_area(widget_x, widget_y, 199, 99);

			if(svc_vpn_status)
				svc_init_vpn(SVC_STOP);
			else
				svc_init_vpn(SVC_START);

			svc_changes |= SVC_VPN;
			draw_vpn_widget(0, widget_x, widget_y); // update service dot
		}

		finalize_tap(vpn_throttle);
	}
}

////////////////////////////////////////////////////////////////////////// WIDGET

s_widget widget_vpn = {"VPN", "/apps/asui_state/cell_vpn", HALF_WIDGET, draw_vpn_widget, click_vpn_widget, 0};
