//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include <stdio.h>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"
#include "hardware.h"

//////////////////////////////////////////////////////////////////////////

void draw_usb_widget( unsigned force, int x, int y ){
	if(force){
		// background for all widgets is cleared by draw_window()
	} else if(hw_changes & HW_USB){
		// widget background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 199, 99);
	} else return;

	draw_text("USB", 32, fg1_color, x+99, y+50, ALIGN_CENTER, ALIGN_MIDDLE, 0);
	draw_text((hw_usb.mode ? "OTG" : "host"), 16, fg1_color, x+99, y+15, ALIGN_CENTER, ALIGN_TOP, 0);
	if(hw_usb.connected){
		char buffer[30];
		snprintf(buffer, sizeof(buffer), "connected [%s]", (hw_usb.connected == 1 ? "host" : "peripheral"));
		draw_text(buffer, 16, red_status_color, x+99, y+70, ALIGN_CENTER, ALIGN_TOP, 0);
	}

	draw_tap_markers(x, y, 99, 0, 1); // long tap only
}

//////////////////////////////////////////////////////////////////////////

void click_usb_widget( ){
	if(click.type == CLICK_HOLD){

		// highlight to indicate long press
		highlight_long_press(widget_x, widget_y, 199, 99);

	} else if(click.type == CLICK_LONG){

		// toggle mode on long press
		highlight_selected_area(widget_x, widget_y, 199, 99);
		hw_toggle_usb_mode();
		draw_usb_widget(0, widget_x, widget_y); // update mode
		x_flush();

	}
}

////////////////////////////////////////////////////////////////////////// WIDGET

s_widget widget_usb = {"USB", "/apps/asui_state/cell_usb", HALF_WIDGET, draw_usb_widget, click_usb_widget, 0};
