//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "main.h"
#include "alarm.h"

//////////////////////////////////////////////////////////////////////////

static GtkWidget *min_volume_widget, *max_volume_widget, *volume_step_label;
static unsigned alarm_duration, min_volume, max_volume;

static void update_volume_step( ){
	char buffer[200];
	snprintf(buffer, sizeof(buffer),
		"Volume is increased by step value every 10 seconds upto maximum level."
		" The step value must be greater than or equal to %u in order for alarm to reach maximum level.",
		100*(max_volume - min_volume)/(alarm_duration-10)
	);
	gtk_label_set_text((GtkLabel *)volume_step_label, (const char *)buffer);
}

static void change_alarm_duration( GObject *gobject, GParamSpec *arg1, gpointer user_data ){
	if(strcmp(arg1->name, "value")) return;
	int value;
	g_object_get(gobject, "value", &value, NULL);
	if(value >= 20 && value <= 3600){
		conf_set_int((const char *)user_data, value);
		alarm_duration = value;
		update_volume_step();
	}
}
static void change_min_volume( GObject *gobject, GParamSpec *arg1, gpointer user_data ){
	if(strcmp(arg1->name, "value")) return;
	int value;
	g_object_get(gobject, "value", &value, NULL);
	if(value >= 10 && value <= 100){
		conf_set_int((const char *)user_data, value);
		min_volume = value;
		if(min_volume > max_volume) hildon_number_editor_set_value((HildonNumberEditor *)max_volume_widget, min_volume);
		update_volume_step();
	}
}

static void change_max_volume( GObject *gobject, GParamSpec *arg1, gpointer user_data ){
	if(strcmp(arg1->name, "value")) return;
	int value;
	g_object_get(gobject, "value", &value, NULL);
	if(value >= 10 && value <= 100){
		conf_set_int((const char *)user_data, value);
		max_volume = value;
		if(max_volume < min_volume) hildon_number_editor_set_value((HildonNumberEditor *)min_volume_widget, max_volume);
		update_volume_step();
	}
}

//////////////////////////////////////////////////////////////////////////

void alarm_click_callback( GtkWidget *widget, gpointer data ){
	new_section_vbox("Alarm"); // add setting widgets to section_content_box

	new_message("Alarm snoozes at the end of duration.");

	alarm_duration = conf_get_int(conf_alarm_duration);
	new_uint_value(conf_alarm_duration, "duration in seconds", 20, 3600, change_alarm_duration);

	min_volume = conf_get_int(conf_alarm_volume_min);
	max_volume = conf_get_int(conf_alarm_volume_max);
	min_volume_widget = new_uint_value(conf_alarm_volume_min, "minimum volume level", 10, 100, change_min_volume);
	max_volume_widget = new_uint_value(conf_alarm_volume_max, "maximum volume level", 10, 100, change_max_volume);

	new_uint_value(conf_alarm_volume_step, "volume step in milliseconds", 0, 1000, NULL);
	volume_step_label = new_message("");
	update_volume_step();

// TODO: snooze interval set by clock app

	new_separator();
}
