// number of events in a single loop before terminating ASUI
#define MAX_RUNAWAY_EVENTS 50

// milliseconds
#define TAP_THROTTLE_DURATION 500

// milliseconds in addition to TAP_THROTTLE_DURATION
// this doesn't help at all when X doesn't respond quickly
#define DIALOG_THROTTLE_DURATION 0

extern unsigned is_770, is_800, is_810;

extern unsigned use_minimal_ui;

//extern unsigned data_refresh_period;

extern int widget_x, widget_y;

typedef struct s_click {
	enum { CLICK_DOWN, CLICK_SHORT, CLICK_HOLD, CLICK_LONG, CLICK_MOTION, CLICK_DRAG } type;
	unsigned button_down;
	unsigned timestamp;
	int start_x, start_y;
	int x, y;
	int offset_x, offset_y;
	int motion_x, motion_y;
	double long_wait;
	unsigned enabled; // used to ignore first button press and release after screen is turned on but not locked
	unsigned popup_window;
} s_click;

extern s_click click;

typedef struct s_keypress {
	enum { KEY_DOWN, KEY_SHORT, KEY_HOLD, KEY_LONG } type;
	unsigned key_down;
	unsigned timestamp;
	int keycode;
	unsigned popup_window;
} s_keypress;

extern s_keypress keypress;

typedef enum e_double_tap_zone {
	Z_NULL,
	Z_MAIN_SVC_AUDIO, Z_MAIN_SVC_BLUETOOTH, Z_MAIN_SVC_GPS, Z_MAIN_SVC_WIFI, Z_MAIN_SVC_DESKTOP, Z_MAIN_SVC_SSH, Z_MAIN_SVC_VPN
} e_double_tap_zone;

typedef struct s_tap_throttler {
	double utime;
	unsigned timestamp;
} s_tap_throttler;

extern s_tap_throttler dialog_throttle, ui_throttle;

typedef struct s_timer {
	double last_time;
	double duration;
	double remaining;
	struct s_timer *next;
} s_timer;

extern double current_time;

extern void (*button_callback)( );
extern unsigned button_autorepeat;

extern s_timer motion_timer;
extern unsigned (*motion_callback)( );

extern unsigned primary_widgets, widget_edit_mode;
typedef struct s_selected_cell {
	struct s_widget_cell *widget_cell;
	unsigned cell;
	unsigned subcell;
} s_selected_cell;
extern s_selected_cell selected_cell;
extern unsigned brightness_widget_page, volume_widget_page, battery_widget_page;
extern unsigned flightmode_button_page, keyrepeat_button_page, screenstayslit_button_page, screenautolock_button_page;

extern unsigned power_unlock_keys[];
extern char *power_unlock_messages[];

extern char *charging_boot_message;

//////////////////////////////////////////////////////////////////////////

#define KEYCODE_ESCAPE 9
#define KEYCODE_ENTER 36
#define KEYCODE_MENU 70
#define KEYCODE_HOME 71
#define KEYCODE_FULLSCREEN 72
#define KEYCODE_ZOOM_PLUS 73
#define KEYCODE_ZOOM_MINUS 74
#define KEYCODE_DPAD_CENTER 104
#ifndef ARCH_armel
#define KEYCODE_DPAD_UP 98
#else
#define KEYCODE_DPAD_UP 111
#endif
#define KEYCODE_DPAD_LEFT 113
#define KEYCODE_DPAD_RIGHT 114
#ifndef ARCH_armel
#define KEYCODE_DPAD_DOWN 104
#else
#define KEYCODE_DPAD_DOWN 116
#endif

#define check_secondary_key(keycode) ((keycode == power_unlock_keys[cfg_power_unlock_key]) || (keycode == KEYCODE_ENTER && power_unlock_keys[cfg_power_unlock_key] == KEYCODE_DPAD_CENTER))

typedef enum { ARROW_RIGHT, ARROW_UP, ARROW_LEFT, ARROW_DOWN } e_arrow_key;

//////////////////////////////////////////////////////////////////////////

double get_utime( );
void set_timer( s_timer *timer, double duration );
void reset_timer( s_timer *timer );
unsigned is_timer_ready( s_timer *timer );

void set_string( char **dst, char *src, unsigned limit );

unsigned file_exists( const char *file );

#ifdef DEBUG
 void debug_write( const char *format, ... );
#else
 #define debug_write(format, ...) {}/* do nothing */
#endif

#ifdef TESTLOG
 void test_write( const char *format, ... );
#else
 #define test_write(format, ...) {}/* do nothing */
#endif

#ifdef TEST
 void error_write( const char *format, ... );
#else
 #define error_write(format, ...) {}/* do nothing */
#endif

void draw_window( unsigned force );

void reboot_handler( );
void shutdown_handler( );

int get_double_tap( e_double_tap_zone zone );
int throttle_taps( s_tap_throttler *zone );
#define finalize_tap(zone) zone.timestamp += (unsigned)((get_utime() - zone.utime)*1000) + TAP_THROTTLE_DURATION

void press_lock_button( unsigned action );
int is_arrow( e_arrow_key arrow );
int dpadlock_keypress_handler( );
int brv_keypress_handler( );

void main_reset( );
unsigned ready_to_read( int fd );
void detect_runlevel_transition( );
